package com.qiho.center.biz.engine.action;

import cn.com.duiba.wolf.utils.DateUtils;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderRuleEnum;
import com.qiho.center.common.dao.QihoItemMerchantDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.merchant.QihoItemMerchantEntity;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/** 24小时同一手机号商家id校验
 * @author chensong
 * @create 2018-04-20 11:42
 **/
public class CountPhoneMerchantAction extends ShotOrderAbstractAction{

    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;

    @Autowired
    private QihoItemMerchantDAO qihoItemMerchantDAO;

    @Override
    public ResultBase<Boolean> valuteCostomByQuery(OrderSnapshotDto orderSnapshotDto, StrategyRuleDto strategyRuleDto) {
        Long merchantId = orderSnapshotDto.getMerchantId();
        if (null == merchantId || merchantId.longValue() < 0L) {
            QihoItemMerchantEntity itemMerchantEntity = qihoItemMerchantDAO.findByItemId(orderSnapshotDto.getItemId());
            if (null == itemMerchantEntity ) {
                ResultBase.errorReturn("获取不到商家信息");
            }
            merchantId = itemMerchantEntity.getMerchantId();
        }


        Date startTime = DateUtils.daysAddOrSub(new Date(),-1);
        Integer count = qihoOrderSnapshotDAO.countByMobileAndMerchantId(orderSnapshotDto.getMobile(),merchantId,startTime);

        return ShotOrderRuleEnum.fromVal(strategyRuleDto.getRuleName()).valuteOrderByQuery(strategyRuleDto.getThreshold(), count);
    }
}
