package com.qiho.center.biz.engine.action;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderRuleEnum;
import com.qiho.center.api.enums.bean.LocationCheckBean;
import com.qiho.center.common.daoh.qiho.CheckAddressMapper;
import com.qiho.center.common.entityd.qiho.CheckAddressEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * IP地址，手机号归属地，收货地址校验
 * Created by weny.cai on 2018/5/11.
 */
public class LocationCheckAction extends ShotOrderAbstractAction{

    @Autowired
    private CheckAddressMapper checkAddressMapper;

    /**
     * 校验
     * @param orderSnapshotDto
     * @param strategyRuleDto
     * @return
     */
    @Override
    public ResultBase<Boolean> valuteCostomByQuery(OrderSnapshotDto orderSnapshotDto, StrategyRuleDto strategyRuleDto) {
        CheckAddressEntity checkAddressEntity = checkAddressMapper.selectByOrderId(orderSnapshotDto.getOrderId());
        if(checkAddressEntity == null){
            return ResultBase.errorReturn("ip mobile归属地 数据未检测 规则无法校验!");
        }
        LocationCheckBean bean = new LocationCheckBean();
        dataWrapper(orderSnapshotDto,checkAddressEntity, bean);
        return ShotOrderRuleEnum
            .fromVal(strategyRuleDto.getRuleName()).valuteOrderByQuery(strategyRuleDto.getThreshold(), bean);
    }

    /**
     * 数据包装处理
     * @param orderSnapshotDto
     * @param checkAddressEntity
     * @param bean
     */
    private void dataWrapper(OrderSnapshotDto orderSnapshotDto,CheckAddressEntity checkAddressEntity, LocationCheckBean bean) {
        if(StringUtils.isNotBlank(orderSnapshotDto.getCity())){
            bean.setCity(orderSnapshotDto.getCity().substring(0,2));
        }else {
            bean.setCity("");
        }
        if(StringUtils.isNotBlank(orderSnapshotDto.getProvince())){
            bean.setProvince(orderSnapshotDto.getProvince().substring(0,2));
        }else {
            bean.setProvince("");
        }

        String ipCity = checkAddressEntity.getIpCity();
        String ipProvince = checkAddressEntity.getIpProvince();

        if(StringUtils.isNotBlank(ipCity)){
            bean.setIpCity(ipCity.substring(0,2));
        }else {
            bean.setIpCity("");
        }
        if(StringUtils.isNotBlank(ipProvince)){
            bean.setIpProvince(ipProvince.substring(0,2));
        }else {
            bean.setIpProvince("");
        }

        bean.setMobileCity(checkAddressEntity.getMobileCity());
        bean.setMobileProvince(checkAddressEntity.getMobileProvince());
    }

}
