package com.qiho.center.biz.engine.coupon;

import com.qiho.center.api.enums.coupon.AstrictMark;
import com.qiho.center.api.exception.QihoException;
import org.springframework.stereotype.Component;

import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by danke on 2017/11/1.
 */
@Component("astrictContextDecider")
public class AstrictContextDecider {

    /** 限制校验模板MAP */
    private static ConcurrentHashMap<AstrictMark, AstrictTemplate> astrictTemplateMap = new ConcurrentHashMap<>();

    /**
     *
     * @author zhanglihui
     * @param astrictMark
     * @return 具体的校验处理器
     */
    public AstrictTemplate decidePayChannel(AstrictMark astrictMark) {
        return astrictTemplateMap.get(astrictMark);
    }

    /**
     * 用于注入限制校验处理器，在spring初始化时被注入
     *
     * @param astrictMark
     * @param astrictTemplate
     */
    public static void registPaychannel(AstrictMark astrictMark, AstrictTemplate astrictTemplate) {
        if (astrictMark == null || astrictTemplate == null) {
            throw new QihoException("registAstrictMark 时参数出现null");
        }
        astrictTemplateMap.put(astrictMark, astrictTemplate);
    }
}
