package com.qiho.center.biz.engine.coupon.astrict;

import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.coupon.ActiveRuleEnum;
import com.qiho.center.api.enums.coupon.AstrictMark;
import com.qiho.center.api.params.AstrictCouponParams;
import com.qiho.center.biz.engine.coupon.AstrictContextDecider;
import com.qiho.center.biz.engine.coupon.AstrictInterface;
import com.qiho.center.biz.engine.coupon.AstrictTemplate;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by danke on 2017/11/1
 * 是否为新用户的校验
 */
@Component
public class NewConsumerAstrictTemplate implements AstrictTemplate<AstrictCouponParams,Object> {

    @Resource
    private QihoOrderSnapshotDAO snapshotDAO;


    @PostConstruct
    public void init(){
        AstrictContextDecider.registPaychannel(getAstrictMarkEnum(),this);
    }

    @Override
    public Boolean astrictProcess(AstrictInterface<AstrictCouponParams, Object> context) {
        AstrictCouponParams astrictVal = context.getAstrictVal();
        //通过手机号和订单状态查询是否存在订单
        String mobile = astrictVal.getMobile();
        List<String> orderStatus = Arrays.stream(OrderStatusEnum.values()).map(OrderStatusEnum::getCode).collect(Collectors.toList());
        List<QihoOrderSnapshotEntity> orderSnapshots = snapshotDAO.findByMobile(mobile,orderStatus);
        return CollectionUtils.isEmpty(orderSnapshots);
    }

    @Override
    public AstrictMark getAstrictMarkEnum() {
        return ActiveRuleEnum.NEW_CONSUMER;
    }

}
