package com.qiho.center.biz.engine.coupon.astrict;

import com.qiho.center.api.enums.coupon.AstrictMark;
import com.qiho.center.api.enums.coupon.CouponAstrictEnum;
import com.qiho.center.api.params.AstrictCouponParams;
import com.qiho.center.biz.engine.coupon.AstrictContextDecider;
import com.qiho.center.biz.engine.coupon.AstrictInterface;
import com.qiho.center.biz.engine.coupon.AstrictTemplate;
import com.qiho.center.common.entity.coupon.QihoCouponConsumerEntity;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * Created by danke on 2017/10/31.
 * 满减校验模板,如果订单金额大于阈值,校验通过
 */
@Component
public class OrderAmtAstrictTemplate implements AstrictTemplate<AstrictCouponParams,QihoCouponConsumerEntity> {

    @PostConstruct
    public void init(){
        AstrictContextDecider.registPaychannel(getAstrictMarkEnum(),this);
    }

    @Override
    public Boolean astrictProcess(AstrictInterface<AstrictCouponParams,QihoCouponConsumerEntity> context) {
        AstrictCouponParams astrictVal = context.getAstrictVal();
        QihoCouponConsumerEntity entity = context.getVerifyModle();
        //校验订单的总价格
        Integer orderAmt = astrictVal.getBuyNum() * astrictVal.getSellingPrice();
        Integer employConditThreshold = entity.getEmployConditThreshold();
        return orderAmt >= employConditThreshold;
    }

    @Override
    public AstrictMark getAstrictMarkEnum() {
        return CouponAstrictEnum.ORDER_AMT;
    }
}
