package com.qiho.center.biz.job;

import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.api.constant.AfterSaleConstant;
import com.qiho.center.api.dto.AfterSaleStageDto;
import com.qiho.center.api.enums.AfterSaleOrderStageEnum;
import com.qiho.center.api.enums.AfterSaleOrderStatusEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.params.AfterSaleQueryParams;
import com.qiho.center.api.util.JSONUtil;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.dao.QihoAfterSaleOrderDAO;
import com.qiho.center.common.dao.QihoFundOrderDAO;
import com.qiho.center.common.dao.QihoOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.fund.QihoFundOrderEntity;
import com.qiho.center.common.entity.order.QihoAfterSaleOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.util.AppLogUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * Created by danke on 2017/10/24.
 */
@Component
public class AftersaleSuccessJob extends AbstractQihoSimpleElasticJob {

    private static final Logger LOGGER = LoggerFactory.getLogger(AftersaleSuccessJob.class);

    @Resource
    private QihoAfterSaleOrderDAO afterSaleOrderDAO;

    @Resource
    private QihoFundOrderDAO qihoFundOrderDAO;

    @Resource
    private QihoOrderDAO qihoOrderDAO;

    @Resource
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        LOGGER.warn("自定更新付款成功状态的售后子订单的定时任务 start");
        StopWatch times = new StopWatch();
        times.start();
        Boolean resultBase = aftersaleSuccessJob();
        times.stop();
        LOGGER.warn("自定更新付款成功状态的售后子订单的定时任务 end wasteTime={} result={}",times.getTime(),resultBase);
    }

    /**
     * 任务半小时执行一次
     * 1000条是现在
     * @return
     */
    @Transactional(DsConstants.DATABASE_QIHO)
    public Boolean aftersaleSuccessJob(){
        AfterSaleQueryParams params = new AfterSaleQueryParams();
        params.setOffset(0);
        params.setMax(200);
        params.setAfterSaleStatus(AfterSaleOrderStatusEnum.AFTER_SALEING.getCode());
        try {
            List<QihoAfterSaleOrderEntity> entities = afterSaleOrderDAO.findAfterSaleByQuery(params);
            if (CollectionUtils.isEmpty(entities))
                return Boolean.TRUE;
            entities.forEach(e ->{
                String afterSaleId = e.getAfterSaleId();
                String metaVal = e.getMetaValue();
                List<AfterSaleStageDto> saleStageDtos = JSONUtil.parseJSONStrToList(AfterSaleConstant.DETAIL_STAGE,metaVal,AfterSaleStageDto.class);
                List<QihoFundOrderEntity> fundEntities = qihoFundOrderDAO.findByAfterSaleId(afterSaleId);
                Long failFundCount = fundEntities.stream().filter(f ->
                        FundStatusEnum.getEnumByCode(f.getFundStatus()) != FundStatusEnum.SUCCESS
                ).count();
                if (0 == failFundCount){
                    //更新售后子订单为成功状态
                    AfterSaleStageDto saleStageDto = new AfterSaleStageDto();
                    saleStageDto.setType(AfterSaleOrderStageEnum.REFUND_SUCCESS.getCode());
                    saleStageDto.setUpdateTime(DateUtils.getSecondStr(new Date()));
                    saleStageDtos.add(saleStageDto);
                    JSONObject metaValueJson = new JSONObject();
                    metaValueJson.put(AfterSaleConstant.DETAIL_STAGE, JSON.toJSONString(saleStageDtos));
                    e.setAfterSaleStatus(AfterSaleOrderStatusEnum.SUCCESS.getCode());
                    e.setMetaValue(metaValueJson.toJSONString());
                    afterSaleOrderDAO.updateAfterSaleOrder(e);
                    //关闭主订单
                    String orderId = e.getOrderId();
                    QihoOrderEntity qihoOrderEntity = new QihoOrderEntity();
                    qihoOrderEntity.setOrderId(orderId);
                    qihoOrderEntity.setOrderStatus(OrderStatusEnum.CLOSED.getCode());
                    qihoOrderEntity.setRemark(AfterSaleConstant.CLOSED_REMARK);
                    qihoOrderDAO.updateByOrderId(qihoOrderEntity);
                    QihoOrderSnapshotEntity qihoOrderSnapshotEntity = new QihoOrderSnapshotEntity();
                    qihoOrderSnapshotEntity.setOrderId(orderId);
                    qihoOrderSnapshotEntity.setOrderStatus(OrderStatusEnum.CLOSED.getCode());
                    qihoOrderSnapshotEntity.setRemark(AfterSaleConstant.CLOSED_REMARK);
                    qihoOrderSnapshotDAO.updateByOrderId(qihoOrderSnapshotEntity);
                }
            });
        }catch (Exception e){
            AppLogUtil.error(LOGGER,"自定更新售后子订单任务失败",e);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}
