package com.qiho.center.biz.job;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.enums.ordersms.SmsMobileStatusEnum;
import com.qiho.center.biz.engine.impl.ShotOrderEngine;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.daoh.qiho.ChuangLanSmsCommitMapper;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderSmsMapper;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.entityd.qiho.ChuangLanSmsCommitEntity;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiOrderSmsEntity;
import com.qiho.center.common.util.HttpClientUtil;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 创蓝超时处理任务
 * Created by weny.cai on 2018/4/23.
 */
@Component
public class ChuangLanSmsTimeOutJob extends AbstractQihoSimpleElasticJob {

    private final static Logger logger = LoggerFactory.getLogger(ChuangLanSmsTimeOutJob.class);

    @Autowired
    ChuangLanSmsCommitMapper chuangLanSmsCommitMapper;

    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;

    @Resource
    private ShotOrderEngine shotOrderEngine;

    @Autowired
    private BaiqiOrderSmsMapper baiqiOrderSmsMapper;

    @Value("${qiho.ssjx.sms.status.push}")
    String pushUrl;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        logger.info("创蓝定时任务开始处理...");
        //查询数据库中1分钟前未处理的任务
        List<ChuangLanSmsCommitEntity> list = chuangLanSmsCommitMapper.selectByTime(new DateTime().minusDays(1).toString("yyyy-MM-dd hh:mm:ss"));
        if (list.isEmpty()){
            return;
        }

        for (ChuangLanSmsCommitEntity chuangLanSmsCommitEntity : list) {

            try{

                // 将order_sms表的mobile字段置为超时
                BaiqiOrderSmsEntity orderSmsParam = new BaiqiOrderSmsEntity();
                orderSmsParam.setMsgId(chuangLanSmsCommitEntity.getMsgId());
                orderSmsParam.setMobileStatus(SmsMobileStatusEnum.TIME_OUT.getNum());
                baiqiOrderSmsMapper.updateMobileByMsgId(orderSmsParam);

                QihoOrderSnapshotEntity entity = qihoOrderSnapshotDAO.findByOrderId(chuangLanSmsCommitEntity.getOrderId());
                if (null == entity) {
                    continue;
                }

                OrderSnapshotDto orderSnapshotDto = BeanUtils.copy(entity,OrderSnapshotDto.class);
                orderSnapshotDto.setSmsRetCode("bq999");
                logger.info("超时处理，订单编号"+entity.getOrderId()+",命中：bq999");
                shotOrderEngine.process(orderSnapshotDto);
                //标记为已处理
                chuangLanSmsCommitEntity.setHandlerStatus(1);
                chuangLanSmsCommitMapper.updateByPrimaryKey(chuangLanSmsCommitEntity);
                //推送给盛世家祥
                Map<String,String> map = new HashMap<>();
                map.put("phone",entity.getMobile());
                map.put("msgBacKcode","TIME_OUT");
                map.put("sendTime",System.currentTimeMillis()+"");
                HttpClientUtil.sendPost(pushUrl,map);
                logger.info("phone:"+entity.getMobile()+",msgBacKcode:TIME_OUT");

            } catch (Exception e){
                logger.error("创蓝定时任务异常,orderId:{},", chuangLanSmsCommitEntity.getOrderId(), e);
            }

        }

        logger.info("创蓝定时任务处理结束...");
    }
}
