package com.qiho.center.biz.job;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.api.enums.ErpManufacturerType;
import com.qiho.center.biz.bo.LogisticsOrderBo;
import com.qiho.center.biz.service.ConfigService;

/**
 * 定时任务，去ERP系统查询物流发货信息. date: 2017年6月8日 下午4:49:50 <br/>
 *
 * @author chencheng
 * @version
 */
@Component
public class ErpLogisticsSyncQueryTaskJob extends AbstractQihoSimpleElasticJob {

    private static final Logger LOGGER = LoggerFactory.getLogger(ErpLogisticsSyncQueryTaskJob.class);

    @Autowired
    private LogisticsOrderBo    logisticsOrderBo;
    @Resource
    private ConfigService configService;

    /**
     * @see com.qiho.center.biz.job.AbstractQihoSimpleElasticJob#doProcess(com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext)
     */
    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        LOGGER.warn("ErpLogisticsSyncQueryJob   启动成功");
        //根据数据库配置判断走e店宝还是旺店通
        ErpManufacturerType erpType = configService.findErpSwitchesType();
        if(erpType == ErpManufacturerType.EDB){
            //e店宝
            logisticsOrderBo.edbErpLogisticsSyncQuery();
        }else {
            //旺店通
            logisticsOrderBo.erpLogisticsSyncQuery();
        }
        LOGGER.info("############## ERP物流信息同步成功(ErpLogisticsSyncQueryTaskJob 执行成功)】##############");
    }

}
