package com.qiho.center.biz.job;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.biz.bo.JDLogisticsSyncBo;
import com.qiho.center.common.dao.QihoLogisticsOrderDAO;
import com.qiho.center.common.entity.logistics.LogisticsOrderEntity;
import com.qiho.center.common.util.AppLogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * Created by weny.cai on 2017/10/27.
 */
@Component
public class JDLogisticsSyncJob extends AbstractQihoSimpleElasticJob{

    private static final Logger logger  = LoggerFactory.getLogger(JDLogisticsSyncJob.class);

    @Autowired
    QihoLogisticsOrderDAO qihoLogisticsOrderDAO;

    @Autowired
    JDLogisticsSyncBo jdLogisticsSyncBo;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        //查询物流子订单中 除非签收成功|退件成功的订单
        AppLogUtil.info(logger, "开始执行定时任务【JDLogisticsSyncBo】 ");
        logger.info("开始执行定时任务【JDLogisticsSyncBo】");
        int pageSize = 100;
        int pageNum = 1;
        long minId = 0;
        while (true) {
            List<LogisticsOrderEntity> list = qihoLogisticsOrderDAO.queryJDListToFix(pageNum, pageSize,minId);
            if (CollectionUtils.isEmpty(list)) {
                break;
            }
            minId = list.get(list.size()-1).getId();
            jdLogisticsSyncBo.syncLogisticsOrderStatus(list);
        }
    }
}
