package com.qiho.center.biz.job;

import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.qiho.center.api.constant.ConfigConstant;
import com.qiho.center.biz.service.monitor.MonitorReportService;
import com.qiho.center.biz.service.order.SmsService;
import com.qiho.center.common.dao.QihoConfigDAO;
import com.qiho.center.common.dao.QihoTemplateDAO;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.entityd.qiho.monitor.LogisticsMonitorReportEntity;
import com.qiho.center.common.enums.SmsTemplateEnum;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by qianjue on 2017/11/7.
 */
@Component
public class LogisticsMonitorSmsSendJob extends AbstractQihoSimpleElasticJob{

	@Resource
	MonitorReportService monitorReportService;
	@Resource
	private SmsService smsService;
	@Resource
	QihoTemplateDAO qihoTemplateDAO;
	@Resource
	QihoConfigDAO  qihoConfigDAO;

	@Override
	protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
		LogisticsMonitorReportEntity entity = monitorReportService.selectMonitorReportForSMS();
		if(null==entity){
			return;
		}
		//查询短信模板
		QihoTemplateEntity template = qihoTemplateDAO.findByCode(SmsTemplateEnum.MONITOR_REPORT.getCode());
		if(null==template || !template.getTemplateEnable()){
			return;
		}
		Map<String,String> context = Maps.newHashMap();
		context.put("monitorDay", String.valueOf(DateUtils.getDayNumber(DateUtils.daysAddOrSub(new Date(),-1))));
		context.put("totalCount",null==entity.getOrderCountTotal() ? "0" : String.valueOf(entity.getOrderCountTotal()));
		context.put("normalCount",null==entity.getOrderCountNormal() ? "0" : String.valueOf(entity.getOrderCountNormal()));
		context.put("yellowCount",null==entity.getOrderCountYellow() ? "0" : String.valueOf(entity.getOrderCountYellow()));
		context.put("redCount",null==entity.getOrderCountRed() ? "0" : String.valueOf(entity.getOrderCountRed()));
		String mobiles = qihoConfigDAO.findByName(ConfigConstant.MONITOR_MOBILE);
		if(StringUtils.isBlank(mobiles)){
			return;
		}
		List<String> mobileList = Splitter.on(",").trimResults().splitToList(mobiles);
		mobileList.stream().forEach(mobile-> smsService.singleSend(template,context,mobile));
	}
}
