package com.qiho.center.biz.job;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.biz.service.finance.AllocateAmountService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 余额分配调用第三方接口，1天内定时任务重试。每两分钟运行
 *
 * @author zhangshun
 * @version V1.0
 * @since 2018-01-02 17:37
 */
@Component
public class RetryCallPartnerAllocateAmountJob extends AbstractQihoSimpleElasticJob {

    private static final Logger LOGGER = LoggerFactory.getLogger(RetryCallPartnerAllocateAmountJob.class);

    @Autowired
    private AllocateAmountService allocateAmountService;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        LOGGER.info("启动>>>>余额分配调用第三方接口");
        allocateAmountService.retryCallPartner();
    }
}
