package com.qiho.center.biz.job;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 广告消耗归档任务
 *
 * @author peanut.huang
 * @date 2018/1/5.
 */
@Component
public class TuiaAdvertConsumeArchiveJob extends AbstractQihoSimpleElasticJob {

    private static final Logger LOGGER = LoggerFactory.getLogger(TuiaAdvertConsumeArchiveJob.class);

    @Resource
    private TuiaAdvertConsumeJob tuiaAdvertConsumeJob;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {

        LOGGER.info("fetch tuia advert consume start...");

        doStart();

        LOGGER.info("fetch tuia advert consume end...");

    }

    /**
     * 归档任务处理，再执行一次消耗任务处理
     *
     */
    public void doStart() {

        tuiaAdvertConsumeJob.setArchive(true);

        tuiaAdvertConsumeJob.doStart(LocalDate.now().minusDays(1), LocalDate.now().minusDays(1));
    }
}
