package com.qiho.center.biz.process.note.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.constant.YZHSmsConstant;
import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.biz.process.note.SmsProcess;
import com.qiho.center.biz.process.note.SmsProcessFactory;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.HttpClientUtil;
import com.qiho.center.common.util.YZHUtil;

/**
 * Created by danke on 2017/9/21.
 */
@Component
public class YZXSmsProcessImpl implements SmsProcess, InitializingBean {

    private static final Logger LOGGER = LoggerFactory.getLogger(YZXSmsProcessImpl.class);

    @Value("${yunzhixun.sms.server}")
    private String server;

    /**
     * 短信发送一级域名
     */
    @Value("${yunzhixun.sms.version}")
    private String version;

    /**
     * 版本
     */
    @Value("${yunzhixun.sms.accountSid}")
    private String accountSid;

    /**
     * 开发者账号ID
     */
    @Value("${yunzhixun.sms.authToken}")
    private String authToken;

    /**
     * 账号授权令牌
     */
    @Value("${yunzhixun.sms.appId}")
    private String appId;

    private String smsSendRetCode(QihoTemplateEntity template, String context, String mobile) {
        try {
            //云之讯需要制定httppost的一些参数
            HttpPost httpPost = YZHUtil
                .createHttpPost(template.getNoteTemplateId(), mobile, context, accountSid, authToken, server, version,
                    appId);
            String resultBase = HttpClientUtil.postUseSelfBody(httpPost, "utf-8");

            if (StringUtils.isNotBlank(resultBase)) {
                JSONObject json = JSON.parseObject(resultBase);
                JSONObject firstCode = json.getJSONObject(YZHSmsConstant.RESP);
                String returnCode = firstCode.getString(YZHSmsConstant.RESPONSE_KEY);
                if (!YZHSmsConstant.YZHCODE.SUCCESS_CODE.equals(returnCode)) {
                    AppLogUtil.warn(LOGGER, "云之讯发送短信异常， mobile={}, text={}, resp={}", mobile, context, resultBase);
                }
                return returnCode;
            }
        } catch (Exception e) {
            LOGGER.error("发送云之讯短信失败 msg={}", e);
        }
        return "300002";
    }

    @Override
    public boolean smsSendByParam(QihoTemplateEntity template, Map<String, String> param, String mobile) {
        String context = getStrParam(template, param);
        return smsSend(template, context, mobile);
    }

    @Override
    public String smsSendByParamRetCode(QihoTemplateEntity template, Map<String, String> param, String mobile) {
        String context = getStrParam(template, param);
        return smsSendRetCode(template, context, mobile);
    }

    @Override
    public boolean smsSend(QihoTemplateEntity template, String mobile) {
        return smsSend(template, StringUtils.EMPTY, mobile);
    }

    @Override
    public String smsSendRetCode(QihoTemplateEntity template, String mobile) {
        return smsSendRetCode(template, StringUtils.EMPTY, mobile);
    }

    private boolean smsSend(QihoTemplateEntity template, String context, String mobile) {
        String returnCode = StringUtils.EMPTY;
        try {
            //云之讯需要制定httppost的一些参数
            HttpPost httpPost = YZHUtil
                .createHttpPost(template.getNoteTemplateId(), mobile, context, accountSid, authToken, server, version,
                    appId);
            String resultBase = HttpClientUtil.postUseSelfBody(httpPost, "utf-8");
            if (StringUtils.isNotBlank(resultBase)) {
                JSONObject json = JSON.parseObject(resultBase);
                JSONObject firstCode = json.getJSONObject(YZHSmsConstant.RESP);
                returnCode = firstCode.getString(YZHSmsConstant.RESPONSE_KEY);
                if (!YZHSmsConstant.YZHCODE.SUCCESS_CODE.equals(returnCode)) {
                    AppLogUtil.warn(LOGGER, "云之讯发送短信异常， mobile={}, text={}, resp={}", mobile, context, resultBase);
                }
            }
        } catch (Exception e) {
            LOGGER.error("发送云之讯短信失败 msg={}", e);
        }
        return YZHSmsConstant.YZHCODE.SUCCESS_CODE.equals(returnCode);
    }

    /**
     * 获取需要发送的内容
     *
     * @param template
     * @param param
     *
     * @return
     */
    private String getStrParam(QihoTemplateEntity template, Map<String, String> param) {
        String templateContext = template.getTemplateContext();
        List<String> variateList = getVariateStr(templateContext);
        if (CollectionUtils.isEmpty(variateList))
            return StringUtils.EMPTY;
        List<String> vals = variateList.stream().map(param::get).collect(Collectors.toList());
        return YZHUtil.getSmsParam(vals);//获取拼接好的发送参数,有序
    }

    /**
     * 获取短信模板中的变量名,有序
     * 截取出字符串中#内的变量名
     */
    private List<String> getVariateStr(String context) {
        List<String> resultBase = new ArrayList<>();
        if (StringUtils.isBlank(context))
            return resultBase;
        Matcher m = Pattern.compile("#(.*?)#").matcher(context);
        while (m.find()) {
            resultBase.add(m.group().replaceAll("#", "").trim());
        }
        return resultBase;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        SmsProcessFactory.registPaychannel(SmsTypeEnum.YUNZHIXUN, this);
    }
}
