/**
 * Project Name:qiho-center-biz File Name:RemoteCategoryServiceImpl.java Package
 * Name:com.qiho.center.biz.remoteservice.impl Date:2017年5月16日下午9:29:15 Copyright (c) 2017, duiba.com.cn All Rights
 * Reserved.
 */

package com.qiho.center.biz.remoteservice.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.CategoryDto;
import com.qiho.center.api.remoteservice.RemoteCategoryService;
import com.qiho.center.biz.service.CategoryService;
import org.springframework.web.bind.annotation.RestController;

/**
 * ClassName:RemoteCategoryServiceImpl <br/>
 * 类目管理dubbo实现类 <br/>
 * Date: 2017年5月16日 下午9:29:15 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@RestController
public class RemoteCategoryServiceImpl implements RemoteCategoryService {

    private static final Logger LOG = LoggerFactory.getLogger(RemoteCategoryServiceImpl.class);
    @Autowired
    private CategoryService     categoryService;

    @Override
    public DubboResult<Void> sortByRange(Long pid, Integer startPayload, Integer endPayload) {
        try {
            categoryService.sortByRange(pid, startPayload, endPayload);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteCategoryService.sortByRange failed, pid={}, startPayload={}, endPayload={}", pid,
                      startPayload, endPayload, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteCategoryService#getCategoryByPid(java.lang.Long)
     */
    @Override
    public DubboResult<List<CategoryDto>> getCategoryByPid(Long pid) {
        try {
            List<CategoryDto> list = categoryService.getCategoryByPid(pid);
            return DubboResult.successResult(list);
        } catch (Exception e) {
            LOG.error("invoke RemoteCategoryService.getCategoryByPid failed, pid={}", pid, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteCategoryService#deleteCategoryById(java.lang.Long)
     */
    @Override
    public DubboResult<Void> deleteCategoryById(Long categoryId) {
        try {
            categoryService.deleteCategoryById(categoryId);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteCategoryService.deleteCategoryById failed, categoryId={}", categoryId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteCategoryService#updateCategoryById(java.lang.Long, java.lang.String)
     */
    @Override
    public DubboResult<Void> updateCategoryById(Long categoryId, String categoryName) {
        try {
            categoryService.updateCategoryById(categoryId, categoryName);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteCategoryService.updateCategoryById failed, categoryId={}, categoryName={}", categoryId, categoryName, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteCategoryService#saveCategory(java.lang.Long, java.util.List)
     */
    @Override
    public DubboResult<List<CategoryDto>> saveCategory(Long pid, List<String> categoryList) {
        try {
            List<CategoryDto> list = categoryService.saveCategory(pid, categoryList);
            return DubboResult.successResult(list);
        } catch (Exception e) {
            LOG.error("invoke RemoteCategoryService.saveCategory failed, pid={}, categoryList={}", pid, categoryList, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}
