package com.qiho.center.biz.remoteservice.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.dto.logistics.LogisticsProcessDto;
import com.qiho.center.api.dto.logistics.QueryLogisticsOrderDto;
import com.qiho.center.api.enums.ErpManufacturerType;
import com.qiho.center.api.enums.LogisticsNameEnum;
import com.qiho.center.api.remoteservice.RemoteLogisticsOrderService;
import com.qiho.center.biz.bo.KuaiDi100Bo;
import com.qiho.center.biz.bo.LogisticsOrderBo;
import com.qiho.center.biz.job.JDLogisticsSyncJob;
import com.qiho.center.biz.service.ConfigService;
import com.qiho.center.biz.service.LogisticsOrderService;
import com.qiho.center.biz.service.logistics.LogisticsQueryDecider;
import com.qiho.center.biz.service.logistics.LogisticsQueryProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * ClassName: RemoteLogisticsOrderServiceImpl <br/>
 * date: 2017年6月3日 下午3:44:25 <br/>
 *
 * @author chencheng
 * @version
 */
@RestController
public class RemoteLogisticsOrderServiceImpl implements RemoteLogisticsOrderService {

    private static final Logger   LOG = LoggerFactory.getLogger(RemoteLogisticsOrderServiceImpl.class);
    @Autowired
    private LogisticsOrderService logisticsOrderService;
    @Autowired
    private LogisticsOrderBo      logisticsOrderBo;
    @Autowired
    private LogisticsQueryDecider logisticsQueryDecider;

    @Autowired
    JDLogisticsSyncJob jdLogisticsSyncJob;
    @Resource
    private ConfigService configService;
	@Resource
    private KuaiDi100Bo kuaiDi100Bo;

    @Override
    public DubboResult<PagenationDto<LogisticsOrderDto>> queryLogisticsOrderPage(QueryLogisticsOrderDto queryItem,
                                                                                 Integer pageNum, Integer pageSize) {
        try {
            PagenationDto<LogisticsOrderDto> page = logisticsOrderService.queryLogisticsOrderPage(queryItem, pageNum,
                                                                                                  pageSize);
            return DubboResult.successResult(page);
        } catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.queryLogisticsOrderPage failed, queryItem={}, pageNum={}, pageSize={}",
                      queryItem, pageNum, pageSize, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> updateBylogisticsId(String logisticsId, String orderStatus) {
        try {
            return DubboResult.successResult(logisticsOrderService.updateBylogisticsId(logisticsId, orderStatus));
        } catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.updateLogisticsOrderStatusBatch failed, logisticsId={}, orderStatus={}",
                      logisticsId, orderStatus, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteLogisticsOrderService#findByOrderId(java.lang.String)
     */
    @Override
    public DubboResult<List<LogisticsOrderDto>> findByOrderId(String orderId) {
        try {
            return DubboResult.successResult(logisticsOrderService.findByOrderId(orderId));
        } catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.findByOrderId failed, orderId={}", orderId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> updateLogisticsOrderStatus(LogisticsOrderDto logisticsOrderDto) {
        try {
            return DubboResult.successResult(logisticsOrderService.update(logisticsOrderDto));
        } catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.updateLogisticsOrderStatus failed, logisticsOrderDto={}",
                      logisticsOrderDto, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<LogisticsProcessDto>> queryYTOLogisticsProcessByPostId(String postId) {
        try {
            LogisticsQueryProcessor processor = logisticsQueryDecider.decideLogisticsQueryProcessor(LogisticsNameEnum.YTO);
            return DubboResult.successResult(processor.queryWaybillTrace(postId));
        } catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.queryLogisticsProcessByPostId failed, postId={}", postId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    /**
     * @see com.qiho.center.api.remoteservice.RemoteLogisticsOrderService#queryWaybillTrace(java.lang.String, java.lang.String)
     */
    @Override
    public DubboResult<List<LogisticsProcessDto>> queryWaybillTrace(String logisticsCode, String postId) {
        try {
            //统一走快递100
            return DubboResult.successResult(kuaiDi100Bo.queryWaybillTrace(logisticsCode,postId));
        } catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.queryWaybillTrace failed, logisticsCode={}, postId={}", logisticsCode, postId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> batchSignOrder(String progressKey, List<LogisticsOrderDto> paramList) {
        try {
            return DubboResult.successResult(logisticsOrderBo.batchSignOrder(progressKey, paramList));
        } catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.batchSignOrder failed, progressKey={}, paramList={}",
                      progressKey, paramList, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> manualErpLogisticsSyncQueryJob() {
        try {
            ErpManufacturerType erpType = configService.findErpSwitchesType();
            if(erpType == ErpManufacturerType.EDB){
                //e店宝
                logisticsOrderBo.edbErpLogisticsSyncQuery();
            }else {
                //旺店通
                logisticsOrderBo.erpLogisticsSyncQuery();
            }
            return DubboResult.successResult(true);
        } catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.batchSignOrder failed", e);
            return DubboResult.failResult("手动触发失败");
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteLogisticsOrderService#syncLogisticsStatus()
     */
    @Override
    public DubboResult<Void> syncLogisticsStatus(String logisticsOrderStatus) {
        try {
            new Thread(() -> logisticsOrderService.syncLogisticsStatus(logisticsOrderStatus)).start();
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.syncLogisticsStatus failed", e);
            return DubboResult.failResult("同步物流状态失败");
        }
    }

    @Override
    public int queryDistributeOverTimeNum() {
        return  logisticsOrderService.queryDistributeOverTimeNum();
    }

    @Override
    public List<LogisticsOrderDto> queryDistributeOverTimePage(Integer pageNum, Integer pageSize) {
        return  logisticsOrderService.queryDistributeOverTimePage(pageNum,pageSize);
    }

    public Boolean updateLogisticsOrderRemark(LogisticsOrderDto param) {
        logisticsOrderService.updateLogisticsOrderRemark(param);
        return Boolean.TRUE;
    }

    @Override
    public PagenationDto<LogisticsOrderDto> queryServiceLogisticsOrder(QueryLogisticsOrderDto queryItem, Integer pageNum, Integer pageSize) {
        return logisticsOrderService.queryServiceLogisticsOrder(queryItem,pageNum,pageSize);
    }

    @Override
    public void syncLogisticsOrderStatus() {
        jdLogisticsSyncJob.process(null);
    }

    @Override
    public Boolean dealKuaiDi100Status(String com, String postId, String status, String condition) {
        return kuaiDi100Bo.dealKuaiDi100Status(com, postId, status,condition);
    }
}
