package com.qiho.center.biz.remoteservice.impl;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.PopupWindowDto;
import com.qiho.center.api.remoteservice.RemotePopupWindowService;
import com.qiho.center.biz.service.PopupWindowService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author: jiafeng.geng
 * @create 2018-05-30
 */
@RestController
public class RemotePopupWindowServiceImpl implements RemotePopupWindowService {

    private static Logger logger = LoggerFactory.getLogger(RemotePopupWindowServiceImpl.class);

    @Resource
    PopupWindowService popupWindowService;

    @Override
    public Integer add(PopupWindowDto popupWindowDto) {
        int result = 0;
        try {
            result = popupWindowService.add(popupWindowDto);
        } catch (Exception e) {
            logger.error("invoke RemotePopupWindowService.add failed, popupWindowDto={}", popupWindowDto, e);
        }
        return result;
    }

    @Override
    public Integer deleteList(List<Long> ids) {
        int result = 0;
        try {
            result = popupWindowService.deleteList(ids);
        } catch (Exception e) {
            logger.error("invoke RemotePopupWindowService.deleteList failed, ids={}", ids, e);
        }
        return result;
    }

    @Override
    public Integer update(PopupWindowDto popupWindowDto) {
        int result = 0;
        try {
            result = popupWindowService.update(popupWindowDto);
        } catch (Exception e) {
            logger.error("invoke RemotePopupWindowService.update failed, popupWindowDto={}", popupWindowDto, e);
        }
        return result;
    }

    @Override
    public PagenationDto<PopupWindowDto> queryList() {
        PagenationDto<PopupWindowDto> pagenation = null;
        try {
            pagenation = popupWindowService.queryList();
        } catch (Exception e) {
            logger.error("invoke RemotePopupWindowService.queryList failed", e);
        }
        return pagenation;
    }

    @Override
    public PagenationDto<PopupWindowDto> queryByParam(PopupWindowDto popupWindowDto) {
        PagenationDto<PopupWindowDto> pagenation = null;
        try {
            pagenation = popupWindowService.queryByParam(popupWindowDto);
        } catch (Exception e) {
            logger.error("invoke RemotePopupWindowService.queryByParam failed, popupWindowDto={}", popupWindowDto, e);
        }
        return pagenation;
    }

    @Override
    public Integer closeOnStatus() {
        int result = 0;
        try {
            result = popupWindowService.closeOnStatus();
        } catch (Exception e) {
            logger.error("invoke RemotePopupWindowService.closeOnStatus failed", e);
        }
        return result;
    }

    @Override
    public PagenationDto<PopupWindowDto> queryByIds(List<Long> ids) {
        PagenationDto<PopupWindowDto> pagenation = null;
        try {
            pagenation = popupWindowService.queryByIds(ids);
        } catch (Exception e) {
            logger.error("invoke RemotePopupWindowService.queryByIds failed, ids={}", ids, e);
        }
        return pagenation;
    }
}
