package com.qiho.center.biz.remoteservice.impl.account;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.account.BaiqiAccountDto;
import com.qiho.center.api.dto.account.BaiqiMainAndAgenAccountDto;
import com.qiho.center.api.enums.account.BaiqiAccountStatusEnum;
import com.qiho.center.api.params.account.AccountPageParam;
import com.qiho.center.api.params.account.BaiqiAccountParam;
import com.qiho.center.api.remoteservice.account.RemoteBaiqiAccountBackendService;
import com.qiho.center.biz.service.account.BaiqiAccountService;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * Created by sunchangji on 2017/12/7.
 */
@RestController
public class RemoteBaiqiAccountBackendServiceImpl implements RemoteBaiqiAccountBackendService {

    @Resource
    private BaiqiAccountService baiqiAccountService;


    @Override
    public PagenationDto<BaiqiMainAndAgenAccountDto> findPageMainAccount(AccountPageParam pageQueryParams) {
        return baiqiAccountService.findPageAccount(pageQueryParams);
    }

    @Override
    public Boolean enableMainAccount(Long id) {
        return baiqiAccountService.enable(id);
    }

    @Override
    public Boolean disableMainAccount(Long id) throws BizException {
        return baiqiAccountService.disableMainAccount(id);
    }

    @Override
    public Boolean insertMainAccount(BaiqiAccountDto accountDto) throws BizException {
        accountDto.setId(null);
        accountDto.setParentId(0L);
        accountDto.setState(BaiqiAccountStatusEnum.ENABLE.getCode());

        return baiqiAccountService.save(accountDto);
    }

    @Override
    public Boolean updateMainAccount(BaiqiAccountParam accountParam) throws BizException {
        BaiqiAccountDto accountDto = new BaiqiAccountDto();
        accountDto.setId(accountParam.getId());
        accountDto.setMobile(accountParam.getMobile());
        accountDto.setPwd(accountParam.getPwd());
        return baiqiAccountService.save(accountDto);
    }
}
