package com.qiho.center.biz.remoteservice.impl.account;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.account.BaiqiAccountDto;
import com.qiho.center.api.remoteservice.account.RemoteSubAccountService;
import com.qiho.center.biz.service.account.BaiqiAccountService;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 子账号
 *
 * @author peanut.huang
 * @date 2017/12/8.
 */
@RestController
public class RemoteSubAccountServiceImpl implements RemoteSubAccountService {

    @Resource
    private BaiqiAccountService baiqiAccountService;

    @Override
    public List<BaiqiAccountDto> findByParentId(Long parentId) {
        return baiqiAccountService.findByParentId(parentId);
    }

    @Override
    public Boolean enable(Long subAid) {
        return baiqiAccountService.enable(subAid);
    }

    @Override
    public Boolean disable(Long subAid) {
        return baiqiAccountService.disable(subAid);
    }

    @Override
    public Boolean delete(Long subAid) {
        return baiqiAccountService.deleteById(subAid);
    }

    @Override
    public Boolean save(BaiqiAccountDto accountDto) throws BizException {
        return baiqiAccountService.save(accountDto);
    }

    @Override
    public BaiqiAccountDto findById(Long subAid) {
        return baiqiAccountService.findById(subAid);
    }
}
