package com.qiho.center.biz.remoteservice.impl.advert;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.advert.ItemAdvertPlanDto;
import com.qiho.center.api.dto.advert.TuiaPlanDto;
import com.qiho.center.api.params.advert.ItemBindPlanParams;
import com.qiho.center.api.params.advert.ItemPlanQueryParams;
import com.qiho.center.api.remoteservice.advert.RemoteItemPlanService;
import com.qiho.center.biz.service.advert.ItemPlanService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author chensong
 * @create 2018-01-08 13:44
 **/
@RestController
public class RemoteItemPlanServiceImpl implements RemoteItemPlanService {

    @Autowired
    private ItemPlanService itemPlanService;

    @Override
    public PagenationDto<ItemAdvertPlanDto> queryPage(ItemPlanQueryParams params) {
        return itemPlanService.queryPage(params);
    }

    @Override
    public List<TuiaPlanDto> getUnbindPlan(Long itemId) {
        return itemPlanService.getUnbindPlan(itemId);
    }

    @Override
    public Boolean bingPlan(ItemBindPlanParams params) throws BizException {
        return itemPlanService.bingPlan(params);
    }
}
