package com.qiho.center.biz.remoteservice.impl.agent;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.agent.AgentMerchantsDto;
import com.qiho.center.api.dto.agent.BaiqiAgentDto;
import com.qiho.center.api.dto.agent.BaiqiAgentMerchantDto;
import com.qiho.center.api.params.agent.AgentMerchantPageParams;
import com.qiho.center.api.remoteservice.agent.RemoteBaiqiAgentService;
import com.qiho.center.biz.bo.BaiqiAgentBO;
import com.qiho.center.biz.service.agent.BaiqiAgentMerchantService;
import com.qiho.center.biz.service.agent.BaiqiAgentService;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentEntity;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.web.bind.annotation.RestController;

import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by sunchangji on 2017/12/20.
 */
@RestController
public class RemoteBaiqiAgentServiceImpl implements RemoteBaiqiAgentService {
    @Resource
    private BaiqiAgentBO baiqiAgentBO;
    @Resource
    private BaiqiAgentService baiqiAgentService;
    @Resource
    private BaiqiAgentMerchantService baiqiAgentMerchantService;

    @Override
    public List<BaiqiAgentMerchantDto> findAgentMerchantsById(Long agentId) {
        return baiqiAgentBO.findAgentMerchantsById(agentId);
    }

    @Override
    public BaiqiAgentDto findBaiqiAgentById(Long agentId) {
        BaiqiAgentEntity agentEntity = baiqiAgentService.findById(agentId);
        return BeanUtils.copy(agentEntity, BaiqiAgentDto.class);
    }

    @Override
    public Boolean validateMerchantId(Long agentId, Long merchantId) {
        return baiqiAgentMerchantService.findByAgentIdAndMerchantId(agentId, merchantId);
    }

    @Override
    public PagenationDto<AgentMerchantsDto> findPageByAgentId(AgentMerchantPageParams pageParams) {
        return baiqiAgentMerchantService.findPageByAgentId(pageParams);
    }

}
