package com.qiho.center.biz.remoteservice.impl.blackList;

import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.bklist.BlackListStrategyDto;
import com.qiho.center.api.remoteservice.blackList.RemoteBlackListStrategrService;
import com.qiho.center.biz.service.blacklist.BlackListStrategyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author chensong
 * @create 2018-04-25 16:42
 **/
@RestController
public class RemoteBlackListStrategrServiceImpl implements RemoteBlackListStrategrService {

    @Autowired
    private BlackListStrategyService blackListStrategyService;

    @Override
    public List<BlackListStrategyDto> listByMerchantId(Long merchantId) {
        return blackListStrategyService.listByMerchantId(merchantId);
    }

    @Override
    public ResultDto<Boolean> createBlackListStrategy(BlackListStrategyDto param) {
        return blackListStrategyService.createBlackStrategy(param);
    }

    @Override
    public ResultDto<Boolean> deleteBlackListStrategy(Long id, String name) {
        return blackListStrategyService.deleteBlackListStrategy(id, name);
    }

    @Override
    public ResultDto updateBlackListStrategy(BlackListStrategyDto param) {
        return blackListStrategyService.updateBlackListStrategy(param);
    }

    @Override
    public BlackListStrategyDto findById(Long id) {
        return blackListStrategyService.findById(id);
    }
}
