package com.qiho.center.biz.remoteservice.impl.coupon;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.coupon.ActiveDto;
import com.qiho.center.api.params.ActiveQueryParams;
import com.qiho.center.api.remoteservice.coupon.RemoteActiveService;
import com.qiho.center.biz.service.coupon.ActiveService;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by danke on 2017/10/31.
 * 活动服务接口
 */
@RestController
public class RemoteActiveServiceImpl implements RemoteActiveService {

    @Resource
    private ActiveService activeService;

    @Override
    public Long insert(ActiveDto dto) {
        return activeService.insert(dto);
    }

    @Override
    public Boolean update(ActiveDto dto) {
        return activeService.update(dto);
    }

    @Override
    public Integer delete(Long activeId) {
        return activeService.delete(activeId);
    }

    @Override
    public ActiveDto findByActiveId(Long activeId) {
        return activeService.findByActiveId(activeId);
    }

    @Override
    public PagenationDto<ActiveDto> findActiveByQuery(ActiveQueryParams params) {
        PagenationDto<ActiveDto> resultBase = new PagenationDto<>();
        Integer count = activeService.countActiveByQuery(params);
        resultBase.setTotal(count);
        if (count > 0){
            List<ActiveDto> list = activeService.findActiveByQuery(params);
            resultBase.setList(list);
        }
        return resultBase;
    }

    @Override
    public ActiveDto findAbleNewsActive() {
        return activeService.findAbleNewsActive();
    }

}
