package com.qiho.center.biz.remoteservice.impl.coupon;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.coupon.CouponConsumerDto;
import com.qiho.center.api.params.AstrictCouponParams;
import com.qiho.center.api.params.CouponConsumerQueryParams;
import com.qiho.center.api.remoteservice.coupon.RemoteCouponConsumerService;
import com.qiho.center.biz.service.coupon.CouponConsumerService;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by danke on 2017/11/1.
 */
@RestController
public class RemoteCouponConsumerServiceImpl implements RemoteCouponConsumerService{

    @Resource
    private CouponConsumerService couponConsumerService;

    @Override
    public Integer insert(CouponConsumerDto dto) {
        return couponConsumerService.insert(dto);
    }

    @Override
    public List<CouponConsumerDto> findAllCouponByMobile(String mobile) {
        return couponConsumerService.findAllCouponByMobile(mobile);
    }

    @Override
    public List<CouponConsumerDto> findCouponUseAble(AstrictCouponParams params) {
        return couponConsumerService.findCouponUseAble(params);
    }

    @Override
    public PagenationDto<CouponConsumerDto> findCouponConsumerByQuery(CouponConsumerQueryParams params) {
        return couponConsumerService.findCouponConsumerByQuery(params);
    }

    @Override
    public List<CouponConsumerDto> consumerGetCoupon(AstrictCouponParams params) {
        return couponConsumerService.consumerGetCoupon(params);
    }

    @Override
    public Boolean verfiyConsumer(AstrictCouponParams params) {
        return couponConsumerService.verfiyConsumer(params);
    }

    @Override
    public List<CouponConsumerDto> findByOrderId(String orderId) {
        return couponConsumerService.findByOrderId(orderId);
    }
}
