package com.qiho.center.biz.remoteservice.impl.finance;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.finance.FinanceDetailDto;
import com.qiho.center.api.dto.finance.HistoricalBalanceDto;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.api.params.finance.BaiqiMerchantFreetextParam;
import com.qiho.center.api.remoteservice.finance.RemoteFinanceDetailService;
import com.qiho.center.biz.service.finance.FinanceDetailService;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * Created by xianhongwei on 2017/12/20.
 */
@RestController
public class RemoteFinanceDetailServiceImpl implements RemoteFinanceDetailService {

    @Resource
    FinanceDetailService financeDetailService;

    @Override
    public PagenationDto<FinanceDetailDto> findByParams(BaiqiMerchantFreetextParam params) {
        return financeDetailService.findByParams(params);
    }

    @Override
    public Long insert(FinanceDetailDto financeDetailDto) {
        return financeDetailService.insert(financeDetailDto);
    }

    @Override
    public PagenationDto<FinanceDetailDto> findFinanceDetailByMerchantId(BaiqiMerchantFreetextParam pageParam) {
        if (BaiqiAccountTypeEnum.AGENT_ACCOUNT.getCode() == pageParam.getRelationType()) {
            return financeDetailService.findFinanceDetailByAgentId(pageParam);
        } else {
            return financeDetailService.findFinanceDetailByMerchantId(pageParam);
        }
    }

    @Override
    public PagenationDto<HistoricalBalanceDto> findHistoricalBalanceByPara(BaiqiMerchantFreetextParam params) {
        return financeDetailService.findHistoricalBalanceByPara(params);
    }

    @Override
    public Integer findIncomeInfoCount() {
        return financeDetailService.findIncomeInfoCount();
    }

    @Override
    public Integer findHistoricalBalanceCount() {
        return financeDetailService.findHistoricalBalanceCount();
    }

    @Override
    public Boolean historicalBalanceSync() {
        return financeDetailService.historicalBalanceSync();
    }
}
