package com.qiho.center.biz.remoteservice.impl.finance;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.finance.AllocateAmountDto;
import com.qiho.center.api.dto.finance.FinanceDto;
import com.qiho.center.api.enums.finance.FinanceStatusEnum;
import com.qiho.center.api.enums.finance.FinanceTypeEnum;
import com.qiho.center.api.enums.finance.PartnerResultStateEnum;
import com.qiho.center.api.params.finance.FinanceBasePageParam;
import com.qiho.center.api.remoteservice.finance.RemoteFinanceService;
import com.qiho.center.biz.service.finance.AllocateAmountService;
import com.qiho.center.biz.service.finance.FinanceService;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * Created by xianhongwei on 2017/12/20.
 */
@RestController
public class RemoteFinanceServiceImpl implements RemoteFinanceService {

    @Autowired
    FinanceService financeService;

    @Resource
    private AllocateAmountService allocateAmountService;

    @Override
    public PagenationDto<FinanceDto> findAll(FinanceBasePageParam pageParam) {
        return financeService.findAll(pageParam);
    }

    @Override
    public PartnerResultStateEnum allocateAmountRecharge(AllocateAmountDto allocateAmountDto) throws BizException {
        return allocateAmountService.allocateAmountRecharge(allocateAmountDto);
    }

    @Override
    public PartnerResultStateEnum allocateAmountReverse(AllocateAmountDto allocateAmountDto) throws BizException {
        return allocateAmountService.allocateAmountReverse(allocateAmountDto);
    }

    @Override
    public FinanceDto findFinanceByMerchantId(long merchantId) {
        return financeService.findFinanceByMerchantId(merchantId);
    }

    @Override
    public FinanceDto findByRelation(FinanceTypeEnum typeEnum, Long relationId) {
        BaiqiFinanceEntity entity = financeService.findByRelation(typeEnum, relationId);
        return transformEntityToDto(entity);
    }

    private FinanceDto transformEntityToDto(BaiqiFinanceEntity entity) {
        if (entity == null) {
            return null;
        }
        FinanceDto financeDto = new FinanceDto();
        financeDto.setRelationType(FinanceTypeEnum.getByCode(entity.getRelationType()));
        financeDto.setRelationId(entity.getRelationId());
        financeDto.setName(entity.getName());
        financeDto.setTotalAmount(entity.getTotalAmount());
        financeDto.setCashAmount(entity.getCashAmount());
        financeDto.setRebateAmount(entity.getRebateAmount());
        financeDto.setState(FinanceStatusEnum.getByCode(entity.getState()));
        financeDto.setDeleted(entity.getDeleted());
        financeDto.setId(entity.getId());
        financeDto.setGmtCreate(entity.getGmtCreate());
        financeDto.setGmtModified(entity.getGmtModified());
        return financeDto;
    }

    @Override
    public Integer findBaseInfoCount() {
        return financeService.findBaseInfoCount();
    }
}
