package com.qiho.center.biz.remoteservice.impl.menu;

import com.qiho.center.api.dto.menu.AccountMenuDto;
import com.qiho.center.api.params.menu.AccountMenuParams;
import com.qiho.center.api.remoteservice.menu.RemoteAccountMenuService;
import com.qiho.center.biz.service.menu.AccountMenuService;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import cn.com.duiba.boot.exception.BizException;

/**
 * 用户菜单接口实现
 *
 * @author zhangshun
 * @version V1.0
 * @since 2017-12-07 18:53
 */
@RestController
public class RemoteAccountMenuServiceImpl implements RemoteAccountMenuService {

    @Autowired
    private AccountMenuService accountMenuService;

    @Override
    public Boolean saveAccountMenuList(Long accountId, Integer accountType, String accountName, List<Long> menuIdList)
        throws BizException {
        return accountMenuService.saveAccountMenuList(accountId, accountType, accountName, menuIdList);
    }

    @Override
    public Boolean updateAccountMenuList(Long accountId, Integer accountType, String accountName, List<Long> menuIdList)
        throws BizException {
        return accountMenuService.updateAccountMenuList(accountId, accountType, accountName, menuIdList);
    }

    @Override
    public Integer deleteByAccountId(Long accountId, Integer accountType, String accountName) throws BizException {
        return accountMenuService.deleteByAccountId(accountId, accountType, accountName);
    }

    @Override
    public List<AccountMenuDto> findByParam(AccountMenuParams params) throws BizException {
        return accountMenuService.findAll();
    }

    @Override
    public List<AccountMenuDto> findByParamAsTree(AccountMenuParams params) throws BizException {
        return accountMenuService.findByParamAsTree(params);
    }

    @Override
    public boolean isOperationByAccountIdAndMenuId(Long accountId, Integer accountType, Long menuId) {
        return accountMenuService.isOperationByAccountIdAndMenuId(accountId, accountType, menuId);
    }

    @Override
    public List<AccountMenuDto> findByAccountId(Long accountId, Integer accountType) throws BizException {
        return accountMenuService.findByAccountId(accountId, accountType);
    }

}
