package com.qiho.center.biz.remoteservice.impl.menu;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.menu.MenuDto;
import com.qiho.center.api.params.menu.MenuParams;
import com.qiho.center.api.remoteservice.menu.RemoteMenuBackendService;
import com.qiho.center.biz.service.menu.MenuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 菜单接口实现
 *
 * @author zhangshun
 * @version V1.0
 * @since 2017-12-07 16:20
 */
@RestController
public class RemoteMenuBackendServiceImpl implements RemoteMenuBackendService {

    @Autowired
    private MenuService menuService;

    @Override
    public Boolean initMenu() {
        return menuService.initMenu();
    }

    @Override
    public Long saveMenu(MenuDto menuDto) throws BizException {
        return menuService.saveMenu(menuDto);
    }

    @Override
    public Integer updateMenu(MenuDto menuDto) throws BizException {
        return menuService.updateMenu(menuDto);
    }

    @Override
    public Integer deleteById(Long id) throws BizException {
        return menuService.deleteById(id);
    }

    @Override
    public Integer deleteByCode(String code) throws BizException {
        return menuService.deleteByCode(code);
    }

    @Override
    public List<MenuDto> findByParam(MenuParams menuParams) throws BizException {
        return menuService.findByParam(menuParams);
    }

}
