package com.qiho.center.biz.remoteservice.impl.merchant;

import cn.com.duiba.boot.exception.BizException;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.SimpleIdAndNameDto;
import com.qiho.center.api.dto.merchant.MerchantAdvertDto;
import com.qiho.center.api.enums.merchant.BaiqiMerchantLinkTypeEnum;
import com.qiho.center.api.remoteservice.merchant.RemoteMerchantAdvertBackendService;
import com.qiho.center.biz.service.advert.BaiqiTuiaAdvertConsumeService;
import com.qiho.center.biz.service.merchant.BaiqiMerchantLinkService;
import com.qiho.center.common.entityd.qiho.merchant.BaiqiMerchantLinkEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 商家广告后台服务
 *
 * @author peanut.huang
 * @date 2017/12/28.
 */
@RestController
public class RemoteMerchantAdvertBackendServiceImpl implements RemoteMerchantAdvertBackendService {

    @Resource
    private BaiqiMerchantLinkService merchantLinkService;
    @Resource
    private BaiqiTuiaAdvertConsumeService tuiaAdvertConsumeService;


    @Override
    public List<MerchantAdvertDto> findAll(Long merchantId) {
        return merchantLinkService.findAllWithUnlinked(merchantId);
    }

    @Override
    public List<SimpleIdAndNameDto> findUnLinkedAdvert() {

        //find all
        List<BaiqiMerchantLinkEntity> allLinkList = merchantLinkService.findByType(BaiqiMerchantLinkTypeEnum.TUI_A);
        if(CollectionUtils.isEmpty(allLinkList)){
            return Collections.emptyList();
        }

        //filter
        List<BaiqiMerchantLinkEntity> unLinkedList = allLinkList.stream()
                                                                .filter(e -> e.getMerchantId() == null)
                                                                .collect(Collectors.toList());
        if(CollectionUtils.isEmpty(unLinkedList)){
            return Collections.emptyList();
        }

        // transfer
        List<SimpleIdAndNameDto> result = Lists.newArrayListWithExpectedSize(unLinkedList.size());
        unLinkedList.forEach(e -> {

            SimpleIdAndNameDto idAndNameDto = new SimpleIdAndNameDto();
            idAndNameDto.setId(e.getRelationId());
            idAndNameDto.setName(e.getRelationName());

            result.add(idAndNameDto);
        });

        return result;
    }

    @Override
    public Boolean insertMerchantAdvert(MerchantAdvertDto merchantAdvertDto) throws BizException {
        Long relationId = merchantLinkService.findRelationIdByMerchantIdAndRelationType(merchantAdvertDto.getMerchantId(), BaiqiMerchantLinkTypeEnum.TUI_A);
        if(relationId != null && relationId != 0L){
            throw new BizException("该商家已关联广告主");
        }
        return merchantLinkService.insert(merchantAdvertDto);
    }

    @Override
    public List<MerchantAdvertDto> findAdvertConsume(Long merchantId, Date startDate, Date endDate) {
        return tuiaAdvertConsumeService.findAdvertConsume(merchantId, startDate, endDate);
    }
}
