package com.qiho.center.biz.remoteservice.impl.merchant;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.merchant.MerchantUndeliveryDto;
import com.qiho.center.api.params.merchant.MerchantUndeliveryQueryParams;
import com.qiho.center.api.remoteservice.merchant.RemoteMerchantUndeliveryBackendService;
import com.qiho.center.biz.service.merchant.MerchantUndeliveryService;
import com.qiho.center.common.entityd.qiho.merchant.BaiqiMerchantUndeliveryEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 商家不配送区域服务
 *
 * @author peanut.huang
 * @date 2018/1/10.
 */
@RestController
public class RemoteMerchantUndeliveryBackendServiceImpl implements RemoteMerchantUndeliveryBackendService {

    @Resource
    private MerchantUndeliveryService merchantUndeliveryService;

    @Override
    public PagenationDto<MerchantUndeliveryDto> find4Page(MerchantUndeliveryQueryParams queryParams) {

        //find list
        List<MerchantUndeliveryDto> undeliveryDtoList = merchantUndeliveryService.findByParams(queryParams);
        if(CollectionUtils.isEmpty(undeliveryDtoList)){
            return new PagenationDto<>();
        }

        PagenationDto<MerchantUndeliveryDto> result = new PagenationDto<>();

        //find total
        int count = merchantUndeliveryService.countByParams(queryParams);

        result.setList(undeliveryDtoList);
        result.setTotal(count);
        return result;
    }

    @Override
    public List<MerchantUndeliveryDto> findByParams(MerchantUndeliveryQueryParams queryParams) {
        return merchantUndeliveryService.findByParams(queryParams);
    }

    @Override
    public Boolean deleteByIds(List<Long> idList) {
        return merchantUndeliveryService.deleteByIds(idList);
    }

    @Override
    public Boolean batchInsert(List<MerchantUndeliveryDto> undeliveryDtoList) {

        return merchantUndeliveryService.batchInsert(BeanUtils.copyList(undeliveryDtoList, BaiqiMerchantUndeliveryEntity.class));
    }
}
