package com.qiho.center.biz.remoteservice.impl.order;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import com.qiho.center.api.constant.YunPianPushConstant;
import com.qiho.center.api.dto.*;
import com.qiho.center.api.dto.order.*;
import com.qiho.center.api.dto.task.BatchOrderTaskDto;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.ShotOrder.OrderProcessWayEnum;
import com.qiho.center.api.params.*;
import com.qiho.center.api.params.MeiLianPushParams;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.api.params.OrderConsumerParam;
import com.qiho.center.api.params.OrderGainParams;
import com.qiho.center.api.params.OrderItemParam;
import com.qiho.center.api.params.OrderPageParams;
import com.qiho.center.api.params.YunPianPushParams;
import com.qiho.center.api.remoteservice.order.RemoteOrderService;
import com.qiho.center.biz.bo.NoteGainBo;
import com.qiho.center.biz.bo.OrderBo;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.biz.service.order.SmsService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * ClassName:RemoteOrderServiceImpl <br/>
 * Date: 2017年6月2日 下午7:19:03 <br/>
 *
 * @author zhanglihui
 * @see
 * @since JDK 1.6
 */
@RestController
public class RemoteOrderServiceImpl implements RemoteOrderService {

    private static final Logger LOG = LoggerFactory.getLogger(RemoteOrderServiceImpl.class);

    @Autowired
    private OrderService orderService;

    @Autowired
    private SmsService smsService;

    @Autowired
    private OrderSnapshotService orderSnapshotService;

    @Autowired
    private OrderBo orderBo;

    @Resource
    private NoteGainBo noteGainBo;

    @Override
    public DubboResult<String> submit(OrderDto order, ChannelInfoDto channelInfo, String payType) {
        try {
            String orderId = orderService.createOrder(order, channelInfo, payType);
            return DubboResult.successResult(orderId);
        } catch (Exception e) {
            LOG.error("invoke RemoteOrderService.submit failed, order={}, channelInfo={}", order, channelInfo, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> sendSmsCode(String mobile, String smsCode) {
        try {
            boolean result = smsService.sendSmsCode(mobile, smsCode);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOG.error("invoke RemoteOrderService.sendSmsCode failed, mobile={}, smsCode={}", mobile, smsCode, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<PagenationDto<OrderSnapshotDto>> findAllPage(OrderPageParams params) {
        return DubboResult.successResult(orderSnapshotService.findOrderPage(params));
    }

    @Override
    public DubboResult<Integer> findAllPageCount(OrderPageParams params) {
        return DubboResult.successResult(orderSnapshotService.findAllPageCount(params));
    }

    @Override
    public DubboResult<List<OrderSnapshotDto>> exportAllOrderPage(OrderPageParams params) {
        return DubboResult.successResult(orderSnapshotService.findOrderPageForExport(params));
    }

    @Override
    public DubboResult<Integer> exportOrderPageCount(OrderPageParams params) {
        return DubboResult.successResult(orderSnapshotService.exportOrderPageCount(params));
    }

    @Override
    public DubboResult<Integer> batchAuditOrder(String progressKey, List<OrderAuditParams> paramList) {
        return DubboResult.successResult(orderBo.batchAuditOrder(progressKey, paramList));
    }

    @Override
    public DubboResult<Boolean> auditOrder(OrderAuditParams params) {
        try {
            return DubboResult.successResult(orderService.auditOrder(params));
        } catch (Exception e) {
            LOG.error("invoke RemoteOrderService.auditOrder failed,orderId={}", params.getOrderId(), e);
            return DubboResult.failResult(e.getMessage());
        }

    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteOrderService#findByOrderId(java.lang.String)
     */
    @Override
    public DubboResult<OrderDto> findByOrderId(String orderId) {
        try {
            OrderDto orderDto = orderService.findByOrderId(orderId);
            return DubboResult.successResult(orderDto);
        } catch (Exception e) {
            LOG.error("invoke RemoteOrderService.findByOrderId failed,orderId={}", orderId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteOrderService#findOrderSnapshot(java.lang.String)
     */
    @Override
    public DubboResult<OrderSnapshotDto> findOrderSnapshot(String orderId) {
        try {
            OrderSnapshotDto orderSnapshotDto = orderSnapshotService.findByOrderId(orderId);
            return DubboResult.successResult(orderSnapshotDto);
        } catch (Exception e) {
            LOG.error("invoke RemoteOrderService.findOrderSnapshot failed,orderId={}", orderId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteOrderService#updateOrderItem(com.qiho.center.api.params.OrderItemParam)
     */
    @Override
    public DubboResult<Void> updateOrderItem(OrderItemParam param) {
        try {
            orderService.updateOrderItem(param);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteOrderService.updateOrderItem failed,param={}", param, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteOrderService#updateOrderConsumer(com.qiho.center.api.params.OrderConsumerParam)
     */
    @Override
    public DubboResult<Void> updateOrderConsumer(OrderConsumerParam param) {
        try {
            orderService.updateOrderConsumer(param);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteOrderService.updateOrderConsumer failed,param={}", param, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteOrderService#updateOrderStatus(java.lang.String, java.lang.String)
     */
    @Override
    public DubboResult<Void> updateOrderStatus(String orderId, String orderStatus) {
        try {
            orderService.updateOrderStatus(orderId, OrderStatusEnum.getByCode(orderStatus));
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteOrderService.updateOrderStatus failed, orderId={}, orderStatus={}", orderId,
                orderStatus, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteOrderService##findByMobile(String, java.util.List)
     */
    @Override
    public DubboResult<List<OrderSnapshotDto>> findByMobile(String mobile, List<String> statusList) {
        try {
            List<OrderSnapshotDto> list = orderSnapshotService.findByMobile(mobile, statusList);
            return DubboResult.successResult(list);
        } catch (Exception e) {
            LOG.error("invoke RemoteOrderService.findByMobile failed,mobile={}, statusList={}", mobile, statusList, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Void> updateOrderWithProcessWay(List<OrderGainParams> orderGainParams) {
        //在这里进行区分,是审核通过/不通过 or 短信捞单
        if (CollectionUtils.isEmpty(orderGainParams))
            return DubboResult.successResult(null);
        //收集其中需要变更为短信捞单的处理参数,并打上处理时间
        List<OrderGainParams> noteGains = orderGainParams.stream().filter(
            e -> null != e.getOrderProcessWayEnum() && e.getOrderProcessWayEnum() == OrderProcessWayEnum.NOTE_GAIN)
            .peek(e -> e.setProcessTime(new Date())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(noteGains)) {
            orderGainParams.removeAll(noteGains);//删除短信捞单,剩余未订单状态变更,若有其他种类,继续删除
            //跟新快照表的处理方式,并发送短信
            List<String> orderIds = noteGains.stream().peek(orderSnapshotService::updateOrderProcessWayByOrderId)
                .map(OrderGainParams::<String>getOrderId).collect(Collectors.toList());
            List<OrderSnapshotDto> noteGainOrders = orderSnapshotService.queryOrderByOrderIds(orderIds);
            noteGainBo.sendGainNote(noteGainOrders);
        }
        try {

            //区分通过和不通过两种状态
            if (CollectionUtils.isEmpty(orderGainParams))
                return DubboResult.successResult(null);
            //将参数转换成订单审核参数
            List<OrderAuditParams> orderAuditParams = orderGainParams.stream().map(this::gainParamToAudit)
                .collect(Collectors.toList());
            for (OrderAuditParams orderAuditParam : orderAuditParams) {
                orderService.auditOrder(orderAuditParam);
            }
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteOrderService.updateOrderWithProcessWay failed,params={}", orderGainParams, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> notePushProcessByYunPain(YunPianPushParams params) {
        try {
            //验签
            boolean checkResult = smsService.checkSign(params);
            if (!checkResult) {
                LOG.warn("短信推送验签失败 param={}", params);
                return DubboResult.failResult("短信推送验签失败");
            }
            //查询最新一单订单
            OrderSnapshotDto resultBase = orderSnapshotService
                .queryByMobileAsNewMost(params.getMobile(), OrderStatusEnum.TO_APPROVE.getCode());
            if (null == resultBase || StringUtils.isBlank(resultBase.getOrderId()))//查询不到,则不再需要推送
                return DubboResult.successResult(Boolean.TRUE);
            //构建审核参数
            OrderAuditParams orderAuditParams = new OrderAuditParams();
            orderAuditParams.setOrderId(resultBase.getOrderId());
            if (StringUtils.equalsIgnoreCase(params.getText(), YunPianPushConstant.YES)) {
                orderAuditParams.setAuditResult(OrderAuditParams.AUDIT_SUCCESS);
            } else if (StringUtils.equalsIgnoreCase(params.getText(), YunPianPushConstant.NO)) {
                orderAuditParams.setAuditResult(OrderAuditParams.AUDIT_FAILED);
                orderAuditParams.setRemark(YunPianPushConstant.NOTE_AUDIT_FAILED);
            }
            return DubboResult.successResult(orderService.auditOrder(orderAuditParams));
        } catch (Exception e) {
            LOG.error("invoke RemoteOrderService.notePushProcessByYunPain failed,param={}", params.toString(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public List<OrderSnapshotDto> queryOrderByOrderIds(List<String> orderIds) {
        if (CollectionUtils.isEmpty(orderIds))
            return new ArrayList<>();
        return orderSnapshotService.queryOrderByOrderIds(orderIds);
    }

    @Override
    public List<OrderSnapshotDto> queryOrderAsNewMost(OrderPageParams pageParams) {
        return orderSnapshotService.queryOrderAsNewMost(pageParams);
    }

    private OrderAuditParams gainParamToAudit(OrderGainParams params) {
        OrderAuditParams orderAuditParams = new OrderAuditParams();
        if (null == params)
            return orderAuditParams;
        orderAuditParams.setOrderId(params.getOrderId());
        orderAuditParams.setAuditResult(params.getOrderStatus());
        if (OrderAuditParams.AUDIT_FAILED == params.getOrderStatus())
            orderAuditParams.setRemark(YunPianPushConstant.MAGIN_CHECK_REMARK);
        return orderAuditParams;
    }

    @Override
    public ItemDetailDto getOrderItemSnapshot(String orderId, Long itemId) {
        return orderService.getOrderItemSnapshot(orderId, itemId);
    }

    @Override
    public OrderDto getLastOrderByMoblie(String mobile) {
        return orderService.getLastOrderByMobile(mobile);
    }

    @Override
    public Boolean isExistOrderByMobileAndItem(String mobile, Long itemId) {
        return CollectionUtils.isNotEmpty(orderSnapshotService.findByMobileAndItem(mobile, itemId));
    }

    @Override
    public Boolean batchAudit(List<OrderAuditParams> paramList) throws BizException {
        if (CollectionUtils.isEmpty(paramList)) {
            throw new BizException("没有需要审核的订单");
        }
        int success = 0;
        for (OrderAuditParams params : paramList) {
            Boolean res = orderService.auditOrder(params);
            if (res) {
                success++;
            }
        }
        return success == paramList.size();
    }

    @Override
    public DubboResult<Boolean> notePushProcessByMeiLian(MeiLianPushParams params) {
        try {
            //查询最新一单订单
            OrderSnapshotDto resultBase = orderSnapshotService
                .queryByMobileAsNewMost(params.getMobile(), OrderStatusEnum.TO_APPROVE.getCode());
            if (null == resultBase || StringUtils.isBlank(resultBase.getOrderId()))//查询不到,则不再需要推送
                return DubboResult.successResult(Boolean.TRUE);
            //构建审核参数
            OrderAuditParams orderAuditParams = new OrderAuditParams();
            orderAuditParams.setOrderId(resultBase.getOrderId());
            if (StringUtils.equalsIgnoreCase(params.getContent(), YunPianPushConstant.YES)) {
                orderAuditParams.setAuditResult(OrderAuditParams.AUDIT_SUCCESS);
            } else if (StringUtils.equalsIgnoreCase(params.getContent(), YunPianPushConstant.NO)) {
                orderAuditParams.setAuditResult(OrderAuditParams.AUDIT_FAILED);
                orderAuditParams.setRemark(YunPianPushConstant.NOTE_AUDIT_FAILED);
            }
            return DubboResult.successResult(orderService.auditOrder(orderAuditParams));
        } catch (Exception e) {
            LOG.error("invoke RemoteOrderService.notePushProcessByYunPain failed,param={}", params.toString(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> notePushProcessByChuangLan(Map<String,String> params) {
        try {
            //查询最新一单订单
            OrderSnapshotDto resultBase = orderSnapshotService
                    .queryByMobileAsNewMost(params.get("mobile"), OrderStatusEnum.TO_APPROVE.getCode());
            if (null == resultBase || StringUtils.isBlank(resultBase.getOrderId())) {//查询不到,则不再需要推送
                return DubboResult.successResult(Boolean.TRUE);
            }
            //构建审核参数
            OrderAuditParams orderAuditParams = new OrderAuditParams();
            orderAuditParams.setOrderId(resultBase.getOrderId());
            if (StringUtils.equalsIgnoreCase(params.get("msg"), YunPianPushConstant.YES)) {
                orderAuditParams.setAuditResult(OrderAuditParams.AUDIT_SUCCESS);
            }
            return DubboResult.successResult(orderService.auditOrder(orderAuditParams));
        } catch (Exception e) {
            LOG.error("invoke RemoteOrderService.notePushProcessByChuangLan failed,param={}", params.toString(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public OrderSnapshotDto findOrderByIdAndMobile(String orderId, String mobile) {
        return orderSnapshotService.findByOderIdAndMobile(orderId,mobile);
    }


    @Override
    public Boolean orderConfirm(OrderConfirmDto orderConfirmDto) throws BizException {
        return orderService.orderConfirm(orderConfirmDto);
    }

    @Override
    public Boolean orderUpdate(OrderConfirmDto orderConfirmDto) throws BizException {
        return orderService.orderUpdate(orderConfirmDto);
    }

    @Override
    public Boolean orderCancel(OrderCancelDto orderCancelDto) throws BizException {
        return orderService.orderCancel(orderCancelDto.getOrderId());
    }

    @Override
    public BatchOrderTaskDto batchOrderConfirm(BatchOrderConfirmDto batchOrderConfirmDto) {
        return orderService.batchOrderConfirm(batchOrderConfirmDto);
    }

    @Override
    public BatchOrderTaskDto batchOrderUpdate(BatchOrderConfirmDto batchOrderConfirmDto) {
        return orderService.batchOrderUpdate(batchOrderConfirmDto);
    }

    @Override
    public BatchOrderTaskDto batchOrderCancel(BatchOrderCancelDto batchOrderCancelDto) {
        return orderService.batchOrderCancel(batchOrderCancelDto);
    }

    @Override
    public BatchOrderTaskDto openBatchOrderConfirm(OpenBatchOrderConfirmDto confirmDto) {
        return orderService.openBatchOrderConfirm(confirmDto);
    }

    @Override
    public BatchOrderTaskDto openBatchOrderCancel(OpenBatchOrderCancelDto cancelDto) {
        return orderService.openBatchOrderCancel(cancelDto);
    }

}
