package com.qiho.center.biz.remoteservice.impl.ordertmp;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.ordertmp.OrderTmpDetailDto;
import com.qiho.center.api.params.ordertmp.OrderTmpPageParam;
import com.qiho.center.api.remoteservice.ordertmp.RemoteOrderTmpService;
import com.qiho.center.biz.service.ordertmp.OrderTmpService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chensong
 * @create 2018-05-17 12:02
 **/
@RestController
public class RemoteOrderTmpServiceImpl implements RemoteOrderTmpService {

    @Autowired
    private OrderTmpService orderTmpService;

    @Override
    public String submitOrderTmp(OrderTmpDetailDto orderDeatil) {
        return orderTmpService.submitTmpOrder(orderDeatil);
    }

    @Override
    public PagenationDto<OrderTmpDetailDto> queryOrderTmpPage(OrderTmpPageParam pageParam) {
        return orderTmpService.queryPage(pageParam);
    }

    @Override
    public ResultDto<Boolean> toValid(String orderId) {
        return orderTmpService.toValid(orderId);
    }

    @Override
    public OrderTmpDetailDto findByOrderId(String orderId) {
        return orderTmpService.findDetailByOrderId(orderId);
    }

    @Override
    public int countPageQuery(OrderTmpPageParam pageParam) {
        return orderTmpService.countPageQuery(pageParam);
    }


}
