/**
 * Project Name:qiho-center-biz
 * File Name:RemotePostsaleServiceImpl.java
 * Package Name:com.qiho.center.biz.remoteservice.impl.postsale
 * Date:2017年6月12日下午7:01:42
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.remoteservice.impl.postsale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.remoteservice.postsale.RemotePostsaleService;
import com.qiho.center.biz.service.postsale.PostsaleService;
import org.springframework.web.bind.annotation.RestController;


/**
 * ClassName:RemotePostsaleServiceImpl <br/>
 * 售后dubbo服务实现类. <br/>
 * Date:     2017年6月12日 下午7:01:42 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@RestController
public class RemotePostsaleServiceImpl implements RemotePostsaleService {
    private static final Logger LOG = LoggerFactory.getLogger(RemotePostsaleServiceImpl.class);
    
    @Autowired
    private PostsaleService postsaleService;
    
    @Override
    public DubboResult<Void> postsaleSuccess(String orderId) {
        try {
            postsaleService.postsaleSuccess(orderId);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteCategoryService.sortByRange failed, orderId={}", orderId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}

