package com.qiho.center.biz.remoteservice.impl.region;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.region.BaiqiRegionDto;
import com.qiho.center.api.dto.region.BaiqiRegionRelationDto;
import com.qiho.center.api.remoteservice.region.RemoteBaiqiRegionService;
import com.qiho.center.biz.service.region.BaiqiRegionService;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 中国省市区乡镇
 * Author: zhanghuifeng
 * Date:   2018/1/16 10:14
 */
@RestController
public class RemoteBaiqiRegionServiceImpl implements RemoteBaiqiRegionService {

    @Resource
    private BaiqiRegionService baiqiRegionService;

    @Override
    public List<BaiqiRegionDto> find(Long parentId) {
        return BeanUtils.copyList(baiqiRegionService.find(parentId), BaiqiRegionDto.class);
    }

    @Override
    public Boolean updateAreaNum(int startId, int endId) {
        return baiqiRegionService.updateAreaNum(startId, endId) > 0;
    }

    @Override
    public Boolean updateAreaNumByRegionName(String regionName, int areaNum) {
        return baiqiRegionService.updateAreaNumByRegionName(regionName, areaNum) > 0;
    }

    @Override
    public List<BaiqiRegionDto> findNullAreaNumRegion(Integer regionLevel) {
        return BeanUtils.copyList(baiqiRegionService.findNullAreaNumRegion(regionLevel),BaiqiRegionDto.class);
    }

    @Override
    public BaiqiRegionRelationDto findRegionByAreaNum(Integer areaNum) {
        return baiqiRegionService.findRegionByAreaNum(areaNum);
    }
}
