package com.qiho.center.biz.remoteservice.impl.sms;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.sms.ChuangLanSmsCommitDto;
import com.qiho.center.api.dto.sms.ChuangLanSmsReportDto;
import com.qiho.center.api.enums.ordersms.OrderSmsReceiveStatus;
import com.qiho.center.api.remoteservice.sms.RemoteChuangLanService;
import com.qiho.center.api.util.OrderSmsUtil;
import com.qiho.center.biz.event.ChuangLanReportReceiveEvent;
import com.qiho.center.biz.service.sms.ChuangLanService;
import com.qiho.center.biz.service.sms.ChuangLanSmsCommitService;
import com.qiho.center.common.daoh.qiho.ChuangLanSmsCommitMapper;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderSmsMapper;
import com.qiho.center.common.entityd.qiho.ChuangLanSmsCommitEntity;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiOrderSmsEntity;
import com.qiho.center.common.support.BizEventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by weny.cai on 2018/4/20.
 */
@RestController
public class RemoteChuangLanServiceImpl implements RemoteChuangLanService{

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteChuangLanServiceImpl.class);

    @Autowired
    ChuangLanSmsCommitService chuangLanSmsCommitService;

    @Autowired
    ChuangLanService chuangLanService;

    @Autowired
    ChuangLanSmsCommitMapper chuangLanSmsCommitMapper;

    @Autowired
    private BizEventBus eventBus;

    @Autowired
    private BaiqiOrderSmsMapper baiqiOrderSmsMapper;


    @Override
    public ChuangLanSmsCommitDto selectByMsgId(String msgId) {
        ChuangLanSmsCommitEntity commitEntity = chuangLanSmsCommitMapper.selectByMsgId(msgId);
        return BeanUtils.copy(commitEntity,ChuangLanSmsCommitDto.class);
    }


    @Override
    public void reportHandler(ChuangLanSmsReportDto dto) {
        DBTimeProfile.enter("RemoteChuangLanServiceImpl.reportHandler");

        // 更新order_sms表
        BaiqiOrderSmsEntity baiqiOrderSmsEntity = updateOrderSms(dto);

        // 发送创蓝消息接收消息
        ChuangLanReportReceiveEvent event = new ChuangLanReportReceiveEvent();
        event.setOrderSmsEntity(baiqiOrderSmsEntity);
        event.setChuangLanSmsReportDto(dto);
        eventBus.post(event);

        ChuangLanSmsCommitEntity commitEntity = chuangLanSmsCommitService.getChuangLanSmsCommitEntity(dto);
        if (commitEntity == null) {
            return;
        }

        DBTimeProfile.enter("invoke ChuangLanService.processReport");
        chuangLanService.processReport(commitEntity,dto);
        DBTimeProfile.release();

        DBTimeProfile.release();
    }


    /**
     * 根据msgId 更新order_sms记录 并返回当前记录
     * 记录不存在返回null
     * @param smsReport
     * @return
     */
    private BaiqiOrderSmsEntity updateOrderSms(ChuangLanSmsReportDto smsReport){
        BaiqiOrderSmsEntity param = new BaiqiOrderSmsEntity();
        param.setMobileStatus(OrderSmsUtil.getReturnCodeByChuangLanStatus(smsReport.getStatus()).getNum());
        param.setMsgId(smsReport.getMsgId());
        param.setMobile(smsReport.getMobile());
        param.setReceiveStatus(OrderSmsReceiveStatus.PROCESSES.getNum());
        int row = baiqiOrderSmsMapper.updateMobileStatus(param);

        if (row == 1) {
            BaiqiOrderSmsEntity orderSmsEntity = baiqiOrderSmsMapper.findByMsgId(smsReport.getMsgId());
            return orderSmsEntity;
        }

        return null;
    }

}
