package com.qiho.center.biz.remoteservice.impl.task;

import com.qiho.center.api.dto.task.OrderConfirmTaskDetailDto;
import com.qiho.center.api.dto.task.OrderConfirmTaskDto;
import com.qiho.center.api.remoteservice.task.RemoteOrderConfirmTaskDetailService;
import com.qiho.center.biz.service.task.OrderConfirmTaskDetailService;
import com.qiho.center.biz.service.task.OrderConfirmTaskService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * Created by weny.cai on 2018/3/28.
 */
@RestController
public class RemoteOrderConfirmTaskDetailServiceImpl implements RemoteOrderConfirmTaskDetailService{

    @Autowired
    OrderConfirmTaskDetailService detailService;

    @Autowired
    private OrderConfirmTaskService confirmTaskService;

    @Override
    public List<OrderConfirmTaskDetailDto> selectByTaskId(Long taskId) {
        return detailService.selectByTaskId(taskId);
    }

    @Override
    public OrderConfirmTaskDto selectTaskByTaskId(String taskId,Long merchantId) {
        return confirmTaskService.selectTaskByTaskId(taskId,merchantId);
    }


}
