package com.qiho.center.biz.remoteservice.impl.user;

import com.qiho.center.api.dto.user.WechatUserDto;
import com.qiho.center.api.remoteservice.user.RemoteWechatUserService;
import com.qiho.center.biz.bo.BaiqiUserBO;
import com.qiho.center.biz.service.user.WechatUserService;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 微信用户服务实现
 * @author peanut.huang
 * @date 2018/1/26.
 */
@RestController
public class RemoteWechatUserServiceImpl implements RemoteWechatUserService {

    @Resource
    private WechatUserService         wechatUserService;

    @Resource
    private BaiqiUserBO               baiqiUserBO;

    @Override
    public Boolean insertUser(WechatUserDto wechatUserDto) {
        return baiqiUserBO.insertWechatUser(wechatUserDto);
    }

    @Override
    public Long findUserIdByMiniOpenId(String miniOpenId) {
        return wechatUserService.findUserIdByMiniOpenId(miniOpenId);
    }
}
