package com.qiho.center.biz.runnable;

import com.google.common.collect.Lists;
import com.qiho.center.common.dao.coupon.QihoCouponActiveDAO;
import com.qiho.center.common.entity.coupon.QihoCouponActiveEntity;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by danke on 2017/11/2.
 * 批量插入活动与优惠券模板绑定信息的runnable
 */
@Component
@Scope("prototype")
public class CouponActiveRunnable implements Runnable {

    @Resource
    private QihoCouponActiveDAO couponActiveDAO;

    private Boolean flagInsertOrDelete;//表示更新还是删除,true=insert false=delete

    private List<QihoCouponActiveEntity> params = Lists.newArrayList();

    @Override
    public void run() {//如果插入失败出现异常直接回滚

        if (flagInsertOrDelete){
            for(QihoCouponActiveEntity param : params){
                couponActiveDAO.insert(param);
            }
        }else {
            for(QihoCouponActiveEntity param : params){
                couponActiveDAO.delete(param);
            }
        }
    }

    public List<QihoCouponActiveEntity> getParams() {
        return params;
    }

    public void setParams(List<QihoCouponActiveEntity> params) {
        this.params = params;
    }

    public Boolean getFlagInsertOrDelete() {
        return flagInsertOrDelete;
    }

    public void setFlagInsertOrDelete(Boolean flagInsertOrDelete) {
        this.flagInsertOrDelete = flagInsertOrDelete;
    }
}
