package com.qiho.center.biz.runnable;

import com.google.common.collect.Lists;
import com.qiho.center.common.dao.coupon.QihoCouponConsumerDAO;
import com.qiho.center.common.entity.coupon.QihoCouponConsumerEntity;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by danke on 2017/11/2.
 */
@Component
@Scope("prototype")
public class CouponRunnable implements Runnable {

    @Resource
    private QihoCouponConsumerDAO couponConsumerDAO;

    private List<QihoCouponConsumerEntity> params = Lists.newArrayList();

    @Override
    public void run() {//如果插入失败出现异常直接回滚
        for(QihoCouponConsumerEntity param : params){
            couponConsumerDAO.insert(param);
        }
    }

    public List<QihoCouponConsumerEntity> getParams() {
        return params;
    }

    public void setParams(List<QihoCouponConsumerEntity> params) {
        this.params = params;
    }
}
