package com.qiho.center.biz.runnable;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.enums.ExpressCompanyEnum;
import com.qiho.center.biz.service.LogisticsOrderService;

@Component
@Scope("prototype")
public class LogisticsOrderSignRunnable implements Runnable {

    private Logger                                      logger    = LoggerFactory.getLogger(LogisticsOrderSignRunnable.class);

    @Autowired
    private LogisticsOrderService                       logisticsOrderService;

    @Resource(name = "stringRedisTemplate")
    private StringRedisTemplate                         redisTemplate;

    private List<LogisticsOrderDto>                     params = Lists.newArrayList();

    private BoundHashOperations<String, String, Object> ops;

    @Override
    public void run() {
        long failCount = 0L;
        try {
            for (LogisticsOrderDto param : params) {
                try {
                    Integer result = logisticsOrderService.update(param);
                    if (result != 1) {
                        failCount++;
                    }
                } catch (Exception e) {
                    failCount++;
                    logger.error("物流订单签收批量失败", e);
                } finally {
                    ops.increment("successCount", 1L);
                }
            }
        } finally {
            ops.increment("failCount", failCount);
            ops.increment("taskCount", -1L);
        }
    }

    public void setProgressKey(String progressKey) {
        this.ops = redisTemplate.boundHashOps(progressKey);
    }

    public void setParams(List<LogisticsOrderDto> params) {
        this.params.addAll(params);
    }

    /**
     * @return
     */
    public Integer enableFilter() {
        List<LogisticsOrderDto> newList = Lists.newArrayList();
        for (LogisticsOrderDto param : this.params) {
            if (StringUtils.isBlank(param.getLogisticsName()) || Objects.equal(null, param.getPostId())
                || Objects.equal(null, ExpressCompanyEnum.getByName(param.getLogisticsName()))
                || StringUtils.isEmpty(param.getOrderStatus())) {
                continue;
            }
            param.setLogisticsCode(ExpressCompanyEnum.getByName(param.getLogisticsName()).getCode());
            newList.add(param);
        }
        params.clear();
        params.addAll(newList);
        return newList.size();
    }
}
