package com.qiho.center.biz.service;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.AbTestSkuDto;
import com.qiho.center.api.dto.ItemSkuDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.TestMetadataQueryParam;

import java.util.List;

/**
 * Created by weny.cai on 2017/10/12.
 */
public interface AbTestSkuService {

    /**
     * 保存AbTestSku
     * @param list
     * @param abTestSkuDto
     * @throws BizException
     */
    void save(List<ItemSkuDto> list, AbTestSkuDto abTestSkuDto) throws BizException;

    /**
     * 删除AbTestSku
     * @param id
     * @throws BizException
     */
    void delete(Long id) throws BizException;

    /**
     * 查询列表
     * @param itemId
     * @return
     */
    PagenationDto<AbTestSkuDto> queryList(TestMetadataQueryParam testMetadataQueryParam)  throws BizException;

    /**
     * 查详情
     * @param id
     * @return
     */
    AbTestSkuDto queryDetail(Long id);

    /**
     * 同步到销售
     * @param id
     */
    void syncToItemSku(Long id,Long userId) throws BizException ;
}
