package com.qiho.center.biz.service;

import com.qiho.center.api.dto.ConfigDto;
import com.qiho.center.api.enums.ErpManufacturerType;
import com.qiho.center.api.params.ConfigParams;
import com.qiho.center.common.entity.QihoConfigEntity;

import java.util.List;

/**
 * 配置项相关Service
 * Created by chensong on 2017/7/17 0017.
 */
public interface ConfigService {

    /**
     * 插入或更新配置项
     * @param param
     * @return
     */
    int saveConfig(ConfigParams param);

    /**
     * 查找所有配置项
     * @return
     */
    List<ConfigDto> findAllConfig();

    /**
     * 根据名称查找配置项
     * @param name
     * @return
     */
    String findByName(String name);

    /**
     * 根据name更新配置项
     * @param param
     * @return
     */
    int updateByName(ConfigParams param);

    /**
     * 查询ERP开关配置,如果配置不正确取defaultErpType的值,
     * 如果defaultErpType不传,取ErpManufacturerType第一个枚举值
     *
     * @return ErpManufacturerType
     */
    ErpManufacturerType findErpSwitchesType();

    QihoConfigEntity findConfigByName(String name);

}
