/**
 * Project Name:qiho-center-biz
 * File Name:ItemService.java
 * Package Name:com.qiho.center.biz.service
 * Date:2017年5月18日上午10:09:20
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.biz.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.qiho.center.api.dto.ItemAdvertDto;
import com.qiho.center.api.dto.ItemDetailDto;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.ItemSimpleDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.item.ItemPageParams;
import com.qiho.center.common.entity.item.QihoItemEntity;

/**
 * ClassName:ItemService <br/>
 * Date:     2017年5月18日 上午10:09:20 <br/>
 *
 * @author zhanglihui
 * @see
 * @since JDK 1.6
 */
public interface ItemService {

    /**
     * 分页查询商品列表
     *
     * @param queryItem
     * @param pageNum
     * @param pageSize
     * @return PagenationDto<ItemDto>
     * @author zhanglihui
     */
    PagenationDto<ItemDto> queryItemPage(ItemDto queryItem, Integer pageNum, Integer pageSize);

    Map<Long, QihoItemEntity> selectByIds(List<Long> itemIds);

    Map<Long, QihoItemEntity> selectByIdList(List<Long> itemIdList);

    /**
     * 创建商品
     *
     * @param itemDetail
     * @return 商品ID
     * @author zhanglihui
     */
    Long createItem(ItemDetailDto itemDetail);

    /**
     * 更新商品信息
     *
     * @param itemDetail
     * @author zhanglihui
     */
    void updateItem(ItemDetailDto itemDetail);

    /**
     * 查询商品详情
     *
     * @param itemId
     * @return ItemDetailDto
     * @author zhanglihui
     */
    ItemDetailDto queryItemDetail(Long itemId);

    /**
     * 批量更新商品状态
     *
     * @param itemIds
     * @param status
     * @author zhanglihui
     */
    void updateStatus(List<Long> itemIds, String status, Long gmtModifier);

    /**
     * 批量删除商品
     *
     * @param itemIds
     * @author zhanglihui
     */
    void deleteBatch(List<Long> itemIds, Long gmtModifier);

    /**
     * 根据ids获取的ItemDto
     *
     * @param itemIds
     * @return List<ItemDto>
     */
    List<ItemDto> findItemDtoByItemIds(Set<Long> itemIds);

    /**
     * 查询首页推荐商品
     *
     * @return List<ItemDto>
     * @author zhanglihui
     */
    List<ItemDto> findRecommendIndex();

    /**
     * 查询商品基本信息
     *
     * @param itemId
     * @return ItemSimpleDto
     * @author zhanglihui
     */
    ItemSimpleDto queryItemSimpleDto(Long itemId);

    List<ItemSimpleDto> queryItemSimpleList(ItemDto queryItem);

    /**
     * 根据商品id更新商品扩展信息extparam
     */
    void updateExtParamByItemId(ItemAdvertDto dto);

    /**
     * 根据商品id查询商品扩展信息
     */
    ItemAdvertDto queryExtParamByItemId(Long itemId);

    /**
     * 根据商品id查询商品总库存
     */
    Long queryItemStockByItemId(Long itemId);

    /**
     * 更新虚拟库存,返回虚拟库存
     */
    Long updateVirtailStock(Long itemId);

    PagenationDto<ItemDto> queryItemPage(ItemPageParams params);
}

