package com.qiho.center.biz.service;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.campaign.MediaWhiteListDto;
import com.qiho.center.api.params.MediaWhiteListQueryParam;
import com.qiho.center.common.entity.campaign.QihoMediaWhiteListEntity;

/**
 *  媒体白名单服务接口
 * Created by qianjue on 2017/9/8.
 */
public interface MediaWhiteListService {


	Long saveOrUpdateWhiteList(MediaWhiteListDto whiteListDto);


	Integer deleteWhiteListById(Long  id);


	PagenationDto<MediaWhiteListDto> queryWhiteListPage(MediaWhiteListQueryParam param);


	QihoMediaWhiteListEntity  queryWhiteListByParam(MediaWhiteListQueryParam param);

	/**
	 * 根据订单ID查询订单的appId是否在白名单内
	 * @param orderId
	 * @return
	 */
	boolean isInWhiteList(String  orderId);

	/**
	 * 校验该app是否在媒体白名单
	 * @param appId
	 * @return true - 是， false - 不是
	 */
	boolean appInWhiteList(Long appId);


	QihoMediaWhiteListEntity  selectWhiteById(Long  id);
}
