package com.qiho.center.biz.service.blacklist;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.bklist.BaiqiBlackListDto;
import com.qiho.center.api.params.blacklist.BaiqiBlackListQueryParam;
import com.qiho.center.api.params.blacklist.BlackListBatchDealParam;

import java.util.List;

/** 新的黑名单相关服务接口
 * @author chensong
 * @create 2018-04-25 12:52
 **/
public interface BaiqiBlackListService {

    /**
     * 黑名单分页查询
     * @param param
     * @return
     */
    PagenationDto<BaiqiBlackListDto> queryPage(BaiqiBlackListQueryParam param);

    /**
     * 删除黑名单
     * @param id
     * @param name 操作人名称
     * @return
     */
    ResultDto<Boolean> deleteBlackList(Long id, String name);

    /**
     * 分页查询统计
     * @param param
     * @return
     */
    int queryPageCount(BaiqiBlackListQueryParam param);

    /**
     * 批量添加黑名单
     * @param cacheKey 任务id
     * @param list  黑名单数据
     * @param merchantId 商家id
     * @return
     */
    int batchAddBlackList(String cacheKey, List<BlackListBatchDealParam> list,Long merchantId , String operator);

}
