package com.qiho.center.biz.service.blacklist;

import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.bklist.BlackListStrategyDto;

import java.util.List;

/** 黑名单策略相关服务
 * @author chensong
 * @create 2018-04-25 14:58
 **/
public interface BlackListStrategyService {

    /**
     * 根据商家id获取黑名单策略
     * @param merchantId -1获取所有的，0获取全部商家，>0查具体的商家
     * @return
     */
    List<BlackListStrategyDto> listByMerchantId(Long merchantId);

    /**
     * 新增黑名单策略
     * @param param
     * @return
     */
    ResultDto<Boolean> createBlackStrategy(BlackListStrategyDto param);

    /**
     * 删除黑名单策略
     * @param id 黑名单策略的id
     * @param name 修改人名称
     * @return
     */
    ResultDto<Boolean> deleteBlackListStrategy(Long id, String name);

    /**
     * 修改黑名单策略
     * @param param
     * @return
     */
    ResultDto<Boolean> updateBlackListStrategy(BlackListStrategyDto param);

    /**
     * 根据策略id查询
     * @param id 黑名单策略的id
     * @return
     */
    BlackListStrategyDto findById(Long id);

}
