package com.qiho.center.biz.service.coupon;

import com.qiho.center.api.dto.coupon.ActiveDto;
import com.qiho.center.api.params.ActiveQueryParams;

import java.util.List;

/**
 * Created by danke on 2017/10/31.
 * 活动的dao
 */
public interface ActiveService {

    /**
     * 新建活动,同时绑定优惠券模板
     * @param dto
     * @return
     */
    Long insert(ActiveDto dto);

    /**
     * 更新活动,同时更新优惠券模板
     * @param dto
     * @return
     */
    Boolean update(ActiveDto dto);

    /**
     * 删除对应活动
     * @param activeId
     * @return
     */
    Integer delete(Long activeId);

    /**
     * 通过活动id查询活动
     * @param activeId
     * @return
     */
    ActiveDto findByActiveId(Long activeId);

    /**
     * 条件分页查询活动
     * @param params
     * @return
     */
    List<ActiveDto> findActiveByQuery(ActiveQueryParams params);

    /**
     * 条件查询活动数量
     */
    Integer countActiveByQuery(ActiveQueryParams params);

    /**
     * 查询最新投放的有效活动
     */
    ActiveDto findAbleNewsActive();
}
