package com.qiho.center.biz.service.coupon;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.coupon.CouponConsumerDto;
import com.qiho.center.api.params.AstrictCouponParams;
import com.qiho.center.api.params.CouponConsumerQueryParams;

import java.util.List;

/**
 * Created by danke on 2017/10/31.
 */
public interface CouponConsumerService {

    Integer insert(CouponConsumerDto dto);

    List<CouponConsumerDto> findAllCouponByMobile(String mobile);

    /**
     * 分页查询发放优惠券
     * @param params
     * @return
     */
    PagenationDto<CouponConsumerDto> findCouponConsumerByQuery(CouponConsumerQueryParams params);

    /**
     * 用户领取优惠券
     * @param params
     * @return
     */
    List<CouponConsumerDto> consumerGetCoupon(AstrictCouponParams params);

    /**
     * 校验用户参与活动资格
     * @param params
     * @return
     */
    Boolean verfiyConsumer(AstrictCouponParams params);

    /**
     * 查询用户可以使用的优惠券
     */
    List<CouponConsumerDto> findCouponUseAble(AstrictCouponParams params);

    List<CouponConsumerDto> findByOrderId(String orderId);
}
