package com.qiho.center.biz.service.finance;

import com.qiho.center.api.dto.BaseResultDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.account.BaiqiFinanceRechargeDetailDto;
import com.qiho.center.api.dto.account.BaiqiFinanceRechargeDto;
import com.qiho.center.api.params.finance.BaiqiFinanceRechargeQryParam;

/**
 * 账户充值service
 * Author: zhanghuifeng
 * Date:   10:00 2017/12/21
 */
public interface BaiqiFinanceRechargeService {

	/**
	 * 分页查询账户充值信息
	 * @param params 查询参数
	 * @return 数据
	 */
	PagenationDto<BaiqiFinanceRechargeDetailDto> find4Page(BaiqiFinanceRechargeQryParam params);

	/**
	 * 新增
	 * @param dto 参数
	 * @return boolean
	 */
	Boolean insert(BaiqiFinanceRechargeDto dto);

	/**
	 * 获取账户充值订单
	 * @param rechargeNo 充值单号
	 * @return 数据
	 */
	BaiqiFinanceRechargeDetailDto findByNo(Long rechargeNo);

	/**
	 * 更新状态
	 * @param state     状态
	 * @param rechargeNo 单号
	 * @param operator   操作人
	 * @return int
	 *
	 */
	BaseResultDto updateState(Integer state, Long rechargeNo, String operator);
}
