package com.qiho.center.biz.service.impl;

import cn.com.duiba.boot.exception.BizException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.AbTestSkuDto;
import com.qiho.center.api.dto.ItemDetailDto;
import com.qiho.center.api.dto.ItemSkuDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.MetadataTypeEnum;
import com.qiho.center.api.params.TestMetadataQueryParam;
import com.qiho.center.biz.service.AbTestSkuService;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.ItemSkuService;
import com.qiho.center.biz.service.abtest.TestMetadataService;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.dao.QihoItemSkuDAO;
import com.qiho.center.common.daoh.qiho.QihoTestMetadataMapper;
import com.qiho.center.common.daoh.qiho.QihoTestPlanMapper;
import com.qiho.center.common.entity.item.QihoItemDetailEntity;
import com.qiho.center.common.entity.item.QihoItemEntity;
import com.qiho.center.common.entity.item.QihoItemSkuEntity;
import com.qiho.center.common.entityd.qiho.abtest.QihoTestMetadataEntity;
import com.qiho.center.common.entityd.qiho.abtest.QihoTestPlanEntity;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * Created by weny.cai on 2017/10/12.
 */
@Service
public class AbTestSkuServiceImpl implements AbTestSkuService {

    @Autowired
    QihoTestMetadataMapper qihoTestMetadataMapper;

    @Autowired
    ItemSkuService itemSkuService;

    @Autowired
    ItemService itemService;

    @Autowired
    QihoTestPlanMapper qihoTestPlanMapper;

    @Autowired
    QihoItemSkuDAO qihoItemSkuDAO;

    @Autowired
    QihoItemDAO qihoItemDAO;

    @Autowired
    TestMetadataService testMetadataService;

    @Override
    public void save(List<ItemSkuDto> list, AbTestSkuDto abTestSkuDto) throws BizException {
        QihoTestMetadataEntity entity = new QihoTestMetadataEntity();
        entity.setId(abTestSkuDto.getId());
        entity.setDataName(abTestSkuDto.getName());
        entity.setDataDesc(abTestSkuDto.getDescription());
        entity.setItemId(abTestSkuDto.getItemId());
        entity.setMetadataKey(MetadataTypeEnum.PRICE.getCode());
        testMetadataService.validateInfo(entity);
        JSONArray jsonArray = new JSONArray();
        for (ItemSkuDto itemSkuDto : list) {
            JSONObject object = new JSONObject();
            object.put("skuId",itemSkuDto.getId());
            object.put("price",itemSkuDto.getSellingPrice());
            object.put("orgPrice",itemSkuDto.getOriginalPrice());
            jsonArray.add(object);
        }
        entity.setMetadataValue(jsonArray.toJSONString());
        //判断是新增还是更新
        if(abTestSkuDto.getId()==null){
            entity.setSkinType(0);
            qihoTestMetadataMapper.insert(entity);
        }else{
            qihoTestMetadataMapper.update(entity);
        }
    }

    @Override
    public void delete(Long id) throws BizException {
        //判断  是否处在计划中  如果处在计划中 不能删除
        List<QihoTestPlanEntity> list = qihoTestPlanMapper.selectValidPlanCountByMetadataId(id);
        if(CollectionUtils.isNotEmpty(list)){
            throw new BizException("本详情已被用于测试方案【测试方案名称】，不允许删除");
        }
        qihoTestMetadataMapper.deleteById(id);
    }

    @Override
    public PagenationDto<AbTestSkuDto> queryList(TestMetadataQueryParam testMetadataQueryParam) throws BizException{
        ItemDetailDto detailDto = itemService.queryItemDetail(testMetadataQueryParam.getItemId());
        PagenationDto<AbTestSkuDto> pagenationDto = new PagenationDto<>();
        if(detailDto==null){ //为空商品不存在
            throw new BizException("商品不存在");
        }
        testMetadataQueryParam.setMetadataKey(MetadataTypeEnum.PRICE.getCode());
        List<QihoTestMetadataEntity> list = qihoTestMetadataMapper.selectListByPage(testMetadataQueryParam);
        List<AbTestSkuDto> result = Lists.newArrayList();
        for (QihoTestMetadataEntity qihoTestMetadataEntity : list) {
            AbTestSkuDto abTestSkuDto = new AbTestSkuDto();
            abTestSkuDto.setDescription(qihoTestMetadataEntity.getDataDesc());
            abTestSkuDto.setName(qihoTestMetadataEntity.getDataName());
            abTestSkuDto.setId(qihoTestMetadataEntity.getId());
            abTestSkuDto.setItemId(qihoTestMetadataEntity.getItemId());
            String value = qihoTestMetadataEntity.getMetadataValue();
            List<HashMap> maps = JSONArray.parseArray(value,HashMap.class);
            List<ItemSkuDto> skus = Lists.newArrayList();
            opsItemSku(maps, skus);
            abTestSkuDto.setSkus(skus);
            result.add(abTestSkuDto);
        }
        int count = qihoTestMetadataMapper.selectListCountByPage(testMetadataQueryParam);
        pagenationDto.setTotal(count);
        pagenationDto.setList(result);
        return pagenationDto;
    }

    /**
     * 把获取到的maps
     * 转化成list<ItemSkuDto>
     * @param maps
     * @param skus
     */
    private void opsItemSku(List<HashMap> maps, List<ItemSkuDto> skus) {
        for(int i=0;i<maps.size();i++){
            String skuId = maps.get(i).get("skuId").toString();
            ItemSkuDto dto = itemSkuService.querySku(Long.valueOf(skuId));
            if(dto!=null){
                String price = maps.get(i).get("price").toString();
                String originalPrice = null;
                if(null != maps.get(i).get("orgPrice")){
                    originalPrice = maps.get(i).get("orgPrice").toString();
                    dto.setOriginalPrice(Integer.valueOf(originalPrice));
                }
                dto.setSellingPrice(Integer.valueOf(price));
                skus.add(dto);
            }
        }
    }

    @Override
    public AbTestSkuDto queryDetail(Long id) {
        AbTestSkuDto result = new AbTestSkuDto();
        QihoTestMetadataEntity qihoTestMetadataEntity = qihoTestMetadataMapper.selectById(id);
        if(qihoTestMetadataEntity == null){
            return null;
        }
        String value = qihoTestMetadataEntity.getMetadataValue();
        List<ItemSkuDto> skus = Lists.newArrayList();
        List<HashMap> list = JSONArray.parseArray(value,HashMap.class);
        List<ItemSkuDto> normalSku = itemSkuService.getSkuByItemId(qihoTestMetadataEntity.getItemId());
        Map<String,ItemSkuDto> normalMaps = toConvert(normalSku);
        if(StringUtils.isNotBlank(value)){
            for(int i=0;i<list.size();i++){
                String skuId = list.get(i).get("skuId").toString();
                if(normalMaps.containsKey(skuId)){
                    normalMaps.remove(skuId);
                }
                ItemSkuDto dto = itemSkuService.querySku(Long.valueOf(skuId));
                if(dto != null){
                    String price = list.get(i).get("price").toString();
                    if(null!= list.get(i).get("orgPrice")){
                        String originalPrice = list.get(i).get("orgPrice").toString();
                        dto.setOriginalPrice(Integer.valueOf(originalPrice));
                    }
                    dto.setSellingPrice(Integer.valueOf(price));
                    skus.add(dto);
                }
            }
        }
        Iterator<Map.Entry<String,ItemSkuDto>> ite =normalMaps.entrySet().iterator();
        while (ite.hasNext()){
            Map.Entry<String,ItemSkuDto> entry = ite.next();
            ItemSkuDto dto = entry.getValue();
            dto.setSellingPrice(null);
            skus.add(dto);
        }
        result.setSkus(skus);
        result.setItemId(qihoTestMetadataEntity.getItemId());
        result.setId(qihoTestMetadataEntity.getId());
        result.setName(qihoTestMetadataEntity.getDataName());
        result.setDescription(qihoTestMetadataEntity.getDataDesc());
        return result;
    }

    private Map<String,ItemSkuDto> toConvert(List<ItemSkuDto> normalSku) {
        Map<String,ItemSkuDto> itemSkuDtoMap = new HashMap<>();
        for (ItemSkuDto dto : normalSku) {
            itemSkuDtoMap.put(String.valueOf(dto.getId()),dto);
        }
        return itemSkuDtoMap;
    }


    @Override
    public void syncToItemSku(Long id,Long userId) throws BizException {
        QihoTestMetadataEntity qihoTestMetadataEntity = qihoTestMetadataMapper.selectById(id);
        if(null == qihoTestMetadataEntity){
            throw new BizException("同步失败:sku组不存在!");
        }
        QihoItemDetailEntity qihoItemDetailEntity = qihoItemDAO.findById(qihoTestMetadataEntity.getItemId());
        if(null==qihoItemDetailEntity){
            throw new BizException("同步失败!");
        }
        if(qihoTestMetadataEntity.getIsDelete()==1){
            throw new BizException("同步失败:sku组不存在!");
        }
        String value = qihoTestMetadataEntity.getMetadataValue();
        List<HashMap> maps = JSONArray.parseArray(value,HashMap.class);
        List<QihoItemSkuEntity> list = Lists.newArrayList();
        for(int i=0;i<maps.size();i++){
            String skuId = maps.get(i).get("skuId").toString();
            String price = maps.get(i).get("price").toString();
            QihoItemSkuEntity dto = new QihoItemSkuEntity();
            dto.setId(Long.valueOf(skuId));
            dto.setSellingPrice(Integer.valueOf(price));
            if(null != maps.get(i).get("orgPrice")){
                String originalPrice = maps.get(i).get("orgPrice").toString();
                dto.setOriginalPrice(Integer.valueOf(originalPrice));
            }
            list.add(dto);
        }
        List<ItemSkuDto> itemSkuDtos = itemSkuService.getSkuByItemId(qihoTestMetadataEntity.getItemId());
        if(maps.size() != itemSkuDtos.size()){
            throw new BizException("同步失败:正常sku有变更!");
        }
        QihoItemEntity itemEntity = new QihoItemEntity();
        itemEntity.setId(qihoTestMetadataEntity.getItemId());
        itemEntity.setGmtModifier(userId);
        itemEntity.setGmtModified(new Date());
        qihoItemDAO.update(itemEntity);
        qihoItemSkuDAO.updateBatch(list);
    }

}