package com.qiho.center.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.constant.ConfigConstant;
import com.qiho.center.api.dto.ConfigDto;
import com.qiho.center.api.enums.ErpManufacturerType;
import com.qiho.center.api.params.ConfigParams;
import com.qiho.center.biz.service.ConfigService;
import com.qiho.center.common.dao.QihoConfigDAO;
import com.qiho.center.common.entity.QihoConfigEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @author chensong
 * @create 2017-07-17 17:31
 **/
@Service
public class ConfigServiceImpl implements ConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigServiceImpl.class);
    @Autowired
    private QihoConfigDAO       qihoConfigDAO;

    @Resource(name = "stringRedisTemplate")
    private StringRedisTemplate redisTemplate;

    /** 缓存key键值前缀 */
    private static final String QIHO_CONFIG_REDIS_PREFIX = "QIHO_CONFIG_";

    @Override
    public int saveConfig(ConfigParams param) {
        QihoConfigEntity entity = new QihoConfigEntity();
        entity.setConfigName(param.getConfigName());
        entity.setConfigValue(param.getConfigValue());
        entity.setDeleted(param.getDeleted());
        if (param.getId() == null) {
            return qihoConfigDAO.insert(entity);
        } else {
            entity.setId(param.getId());
            entity.setGmtModified(param.getGmtModified());
            return qihoConfigDAO.update(entity);
        }

    }

    @Override
    public QihoConfigEntity findConfigByName(String name){
        return qihoConfigDAO.findConfigByName(name);
    }

    @Override
    public List<ConfigDto> findAllConfig() {
        List<QihoConfigEntity> entityList = qihoConfigDAO.findAllConfig();
        return BeanUtils.copyList(entityList, ConfigDto.class);
    }

    @Override
    public String findByName(String name) {
        String configValue = redisTemplate.opsForValue().get(QIHO_CONFIG_REDIS_PREFIX + name);
        if (StringUtils.isBlank(configValue)) {
            configValue = qihoConfigDAO.findByName(name);
            if(StringUtils.isNotBlank(configValue)){
                redisTemplate.opsForValue().set(QIHO_CONFIG_REDIS_PREFIX + name, configValue, 1, TimeUnit.MINUTES);
            }
        }
        return configValue;
    }

    @Override
    public int updateByName(ConfigParams param) {
        QihoConfigEntity entity = new QihoConfigEntity();
        entity.setConfigName(param.getConfigName());
        entity.setConfigValue(param.getConfigValue());
        entity.setDeleted(param.getDeleted());
        int update = qihoConfigDAO.updateByName(entity);
        redisTemplate.opsForValue().set(QIHO_CONFIG_REDIS_PREFIX + param.getConfigName(), param.getConfigValue(), 1,
                TimeUnit.MINUTES);
        return update;
    }

    @Override
    public ErpManufacturerType findErpSwitchesType() {
        String erpSwitchConfig = this.findByName(ConfigConstant.ERP_MANUFACTURER_TYPE);
        erpSwitchConfig = StringUtils.trimToNull(erpSwitchConfig);
        if (null == erpSwitchConfig) {
            return ErpManufacturerType.EDB;
        }
        ErpManufacturerType manufacturerType = ErpManufacturerType.getErpTypeByCode(erpSwitchConfig.toUpperCase());
        if (null == manufacturerType) {
            LOGGER.error("EPR 开关配置error,请及时检查,开关已切成默认模式,{}", ErpManufacturerType.EDB.getDesc());
            return ErpManufacturerType.EDB;
        }
        return manufacturerType;
    }

}
